package me.alexdevs.solstice.modules.warp.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.warp.WarpModule;
import me.alexdevs.solstice.modules.warp.data.WarpServerData;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9247;

public class WarpsCommand extends ModCommand<WarpModule> {
    public WarpsCommand(WarpModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("warps");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var source = context.getSource();
                    var serverDate = Solstice.serverData.getData(WarpServerData.class);
                    var warpList = serverDate.warps.keySet().stream().sorted().toList();
                    var sourceContext = PlaceholderContext.of(source);

                    if(source.method_43737()) {
                        var player = source.method_44023();
                        warpList = warpList.stream().filter(warp -> module.canUseWarp(player, warp)).toList();
                    }

                    if (warpList.isEmpty()) {
                        context.getSource().method_9226(() -> module.locale().get(
                                "noWarps",
                                sourceContext
                        ), false);
                        return 1;
                    }

                    var listText = class_2561.method_43473();
                    var comma = module.locale().get("warpsComma");
                    for (var i = 0; i < warpList.size(); i++) {
                        if (i > 0) {
                            listText = listText.method_10852(comma);
                        }
                        var placeholders = Map.of(
                                "warp", class_2561.method_30163(warpList.get(i))
                        );

                        listText = listText.method_10852(module.locale().get(
                                "warpsFormat",
                                sourceContext,
                                placeholders
                        ));
                    }

                    var placeholders = Map.of(
                            "warpList", (class_2561) listText
                    );
                    context.getSource().method_9226(() -> module.locale().get(
                            "warpList",
                            sourceContext,
                            placeholders
                    ), false);

                    return 1;
                });
    }
}