package me.alexdevs.solstice.modules.back.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Components;
import me.alexdevs.solstice.modules.back.BackModule;
import net.minecraft.class_2168;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9247;

public class BackCommand extends ModCommand<BackModule> {
    public BackCommand(BackModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("back");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9247("force")
                        .executes(context -> execute(context, true))
                )
                .executes(context -> execute(context, false));
    }

    private int execute(CommandContext<class_2168> context, boolean force) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var playerContext = PlaceholderContext.of(player);

        var lastPosition = module.getPlayerLastLocation(player.method_5667());
        if (lastPosition == null) {
            context.getSource().method_9226(() -> module.locale().get(
                    "noPosition",
                    playerContext
            ), false);
            return 1;
        }

        context.getSource().method_9226(() -> module.locale().get(
                "teleporting",
                playerContext
        ), false);
        if (force) {
            lastPosition.teleport(player);
        } else {
            var range = module.getConfig().safeCheckRange;
            var success = lastPosition.safeTeleport(player, true, range);
            if (!success) {
                var placeholders = Map.of(
                        "forceBackButton", Components.button(
                                module.locale().raw("forceLabel"),
                                module.locale().raw("forceHover"),
                                "/back force"
                        )
                );

                context.getSource().method_9226(() -> module.locale().get(
                        "teleportFailed",
                        playerContext,
                        placeholders
                ), false);
            }
        }

        return 1;
    }

}
