package me.alexdevs.solstice.modules.ban.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.ban.BanModule;
import net.minecraft.class_2168;
import net.minecraft.class_2191;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TempBanCommand extends ModCommand<BanModule> {
    public TempBanCommand(BanModule module) {
        super(module);
    }

    private static Date getDateFromNow(int seconds) {
        var now = new Date();
        var c = Calendar.getInstance();
        c.setTime(now);
        c.add(Calendar.SECOND, seconds);
        return c.getTime();
    }

    @Override
    public List<String> getNames() {
        return List.of("tempban");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("tempban", 3))
                .then(method_9244("targets", class_2191.method_9329())
                        .then(method_9244("duration", StringArgumentType.string())
                                .suggests(TimeSpan::suggest)
                                .executes(context -> execute(context, class_2191.method_9330(context, "targets"), null, TimeSpan.getTimeSpan(context, "duration")))
                                .then(method_9244("reason", StringArgumentType.greedyString())
                                        .executes(context -> execute(context, class_2191.method_9330(context, "targets"), StringArgumentType.getString(context, "reason"), TimeSpan.getTimeSpan(context, "duration"))))));

    }

    private int execute(CommandContext<class_2168> context, Collection<GameProfile> targets, String reason, int duration) throws CommandSyntaxException {
        var expiryDate = getDateFromNow(duration);

        return BanCommand.execute(context, targets, reason, expiryDate);
    }
}
