package me.alexdevs.solstice.modules.ban.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.module.Utils;
import me.alexdevs.solstice.modules.ban.BanModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import java.util.Collection;
import java.util.List;

import static net.minecraft.class_2170.method_9247;

public class UnbanCommand extends ModCommand<BanModule> {
    private static final SimpleCommandExceptionType ALREADY_UNBANNED_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43471("commands.pardon.failed"));

    public UnbanCommand(BanModule module) {
        super(module);
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        Utils.removeCommands(dispatcher, "pardon");
        super.register(dispatcher, commandRegistry, environment);
    }

    @Override
    public List<String> getNames() {
        return List.of("unban", "pardon");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(3))
                .then(class_2170.method_9244("targets", class_2191.method_9329())
                        .suggests((context, builder) -> class_2172.method_9253((context.getSource()).method_9211().method_3760().method_14563().method_14636(), builder))
                        .executes(context -> execute(context, class_2191.method_9330(context, "targets"))));
    }

    private int execute(CommandContext<class_2168> context, Collection<GameProfile> targets) throws CommandSyntaxException {
        var banList = context.getSource().method_9211().method_3760().method_14563();
        var source = context.getSource();
        var pardonCount = 0;
        for (GameProfile profile : targets) {
            if (banList.method_14650(profile)) {
                banList.method_14635(profile);
                pardonCount++;
                source.method_9226(() -> class_2561.method_43469("commands.pardon.success", class_2561.method_30163(profile.getName())), true);
            }
        }

        if (pardonCount == 0) {
            throw ALREADY_UNBANNED_EXCEPTION.create();
        } else {
            return pardonCount;
        }
    }
}
