package me.alexdevs.solstice.modules.ban.formatters;

import com.mojang.authlib.GameProfile;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.ban.BanModule;
import net.minecraft.class_2561;
import net.minecraft.class_3336;
import java.text.SimpleDateFormat;
import java.util.Map;

public class BanMessageFormatter {
    public static class_2561 format(GameProfile profile, class_3336 entry) {
        var locale = ModuleProvider.BAN.locale();
        var coreConfig = CoreModule.getConfig();
        var df = new SimpleDateFormat(coreConfig.dateTimeFormat);

        var context = PlaceholderContext.of(profile, Solstice.server);
        var expiryDate = class_2561.method_30163(entry.method_14502() != null ? df.format(entry.method_14502()) : "never");
        Map<String, class_2561> placeholders = Map.of(
                "reason", Format.parse(entry.method_14503(), context),
                "creation_date", class_2561.method_30163(df.format(entry.method_34885())),
                "expiry_date", expiryDate,
                "source", class_2561.method_30163(entry.method_14501())
        );

        var format = entry.method_14502() != null ? locale.raw("tempBanMessageFormat") : locale.raw("banMessageFormat");

        return Format.parse(format, context, placeholders);
    }
}
