package me.alexdevs.solstice.modules.commandSpy;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.CommandEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.commandSpy.data.CommandSpyConfig;
import me.alexdevs.solstice.modules.commandSpy.data.CommandSpyLocale;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.Map;

public class CommandSpyModule extends ModuleBase.Toggleable {
    

    public CommandSpyModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerConfig(CommandSpyConfig.class, CommandSpyConfig::new);
        registerLocale(CommandSpyLocale.MODULE);

        CommandEvents.ALLOW_COMMAND.register((source, command) -> {
            if (!source.method_43737())
                return true;

            Solstice.LOGGER.info("{}: /{}", source.method_9214(), command);

            var parts = command.split("\\s");
            if (parts.length >= 1) {
                var cmd = parts[0];
                if (isIgnored(cmd)) {
                    return true;
                }
            }

            var player = source.method_44023();

            var players = source.method_9211().method_3760().method_14571();
            var placeholders = Map.of("player", class_2561.method_30163(player.method_7334().getName()), "command", class_2561.method_30163(command));
            var message = locale().get("spyFormat", placeholders);
            for (var pl : players) {
                var commandSpyEnabled = Permissions.check(pl, this.getPermissionNode("base"));

                if (commandSpyEnabled && !pl.method_5667().equals(player.method_5667())) {
                    pl.method_7353(message, false);
                }
            }
            return true;
        });

    }

    public boolean isIgnored(String command) {
        if(!isEnabled())
            return false;

        return Solstice.configManager.getData(CommandSpyConfig.class).ignoredCommands.contains(command);
    }
}
