package me.alexdevs.solstice.modules.fly.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.fly.FlyModule;
import me.alexdevs.solstice.modules.fly.data.FlyPlayerData;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class FlyCommand extends ModCommand<FlyModule> {
    public FlyCommand(FlyModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("fly");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(3))
                .executes(context -> execute(context, null))
                .then(method_9244("player", class_2186.method_9305())
                        .requires(require("others", 3))
                        .executes(context -> execute(context, class_2186.method_9315(context, "player")))
                );
    }

    private int execute(CommandContext<class_2168> context, @Nullable class_3222 player) throws CommandSyntaxException {
        var forOther = player != null;
        if (player == null) {
            player = context.getSource().method_9207();
        }

        var abilities = player.method_31549();
        abilities.field_7478 = !abilities.field_7478;

        var data = Solstice.playerData.get(player).getData(FlyPlayerData.class);
        data.flightEnabled = abilities.field_7478;

        if(!abilities.field_7478) {
            abilities.field_7479 = false;
        }

        player.method_7355();

        class_2561 text;
        var sourceContext = PlaceholderContext.of(context.getSource());
        if (forOther) {
            var placeholders = Map.of(
                    "player", player.method_5476()
            );

            if (abilities.field_7478) {
                text = module.locale().get("enabledForOther", sourceContext, placeholders);
            } else {
                text = module.locale().get("disabledForOther", sourceContext, placeholders);
            }
        } else {
            if (abilities.field_7478) {
                text = module.locale().get("enabled", sourceContext);
            } else {
                text = module.locale().get("disabled", sourceContext);
            }
        }

        context.getSource().method_9226(() -> text, forOther);

        return 1;
    }
}
