package me.alexdevs.solstice.modules.ignore.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.ignore.IgnoreModule;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9247;

public class IgnoreListCommand extends ModCommand<IgnoreModule> {
    public IgnoreListCommand(IgnoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("ignorelist");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var playerData = module.getPlayerData(player.method_5667());
                    var ignoreList = playerData.ignoredPlayers;
                    var playerContext = PlaceholderContext.of(player);

                    if (ignoreList.isEmpty()) {
                        context.getSource().method_9226(() -> module.locale().get("ignoreListEmpty",
                                playerContext
                        ), false);
                        return 1;
                    }

                    var listText = class_2561.method_43473();
                    var comma = module.locale().get("ignoreListComma");
                    for (var i = 0; i < ignoreList.size(); i++) {
                        if (i > 0) {
                            listText = listText.method_10852(comma);
                        }

                        String playerName;
                        var gameProfile = context.getSource().method_9211().method_3793().method_14512(ignoreList.get(i));
                        if (gameProfile.isPresent()) {
                            playerName = gameProfile.get().getName();
                        } else {
                            playerName = ignoreList.get(i).toString();
                        }

                        var placeholders = Map.of(
                                "player", class_2561.method_30163(playerName)
                        );

                        listText = listText.method_10852(module.locale().get(
                                "ignoreListFormat",
                                playerContext,
                                placeholders
                        ));
                    }

                    var placeholders = Map.of(
                            "playerList", (class_2561) listText
                    );
                    context.getSource().method_9226(() -> module.locale().get(
                            "ignoreList",
                            playerContext,
                            placeholders
                    ), false);

                    return 1;
                });
    }
}
