package me.alexdevs.solstice.modules.info.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.info.InfoModule;
import net.minecraft.class_2168;
import java.util.List;

import static net.minecraft.class_2170.method_9247;

public class MotdCommand extends ModCommand<InfoModule> {
    public MotdCommand(InfoModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("motd");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("motd", true))
                .executes(context -> {
                    var sourceContext = PlaceholderContext.of(context.getSource());

                    context.getSource().method_45068(module.buildMotd(sourceContext));

                    return 1;
                });
    }
}
