package me.alexdevs.solstice.modules.item.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.item.ItemModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;

public class ItemLoreCommand extends ModCommand<ItemModule> {
    public ItemLoreCommand(ItemModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("lore", "itemlore");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("lore", 2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var item = player.method_6047();

                    if (item.method_7960()) {
                        context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                        return 0;
                    }

                    item.method_57381(class_9334.field_49632);

                    context.getSource().method_9226(() -> module.locale().get("loreCleared"), false);

                    return 1;
                })
                .then(class_2170.method_9244("lore", StringArgumentType.greedyString())
                        .executes(context -> {
                            var player = context.getSource().method_9207();
                            var item = player.method_6047();
                            var itemLore = StringArgumentType.getString(context, "lore");

                            if (item.method_7960()) {
                                context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                                return 0;
                            }

                            var playerContext = PlaceholderContext.of(player);
                            var list = new ArrayList<class_2561>();
                            for(var line : itemLore.split("\\\\n")) {
                                list.add(Format.parse(line, playerContext));
                            }

                            item.method_57379(class_9334.field_49632, new class_9290(list));

                            context.getSource().method_9226(() -> module.locale().get("loreSet"), false);

                            return 1;
                        })
                );
    }
}
