package me.alexdevs.solstice.modules.item.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.item.ItemModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_9334;
import java.util.List;

public class ItemNameCommand extends ModCommand<ItemModule> {
    public ItemNameCommand(ItemModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("itemname");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("name", 2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var item = player.method_6047();

                    if(item.method_7960()) {
                        context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                        return 0;
                    }

                    item.method_57381(class_9334.field_49631);

                    context.getSource().method_9226(() -> module.locale().get("nameCleared"), false);

                    return 1;
                })
                .then(class_2170.method_9244("name", StringArgumentType.greedyString())
                        .executes(context -> {
                            var player = context.getSource().method_9207();
                            var item = player.method_6047();
                            var itemName = StringArgumentType.getString(context, "name");

                            if(item.method_7960()) {
                                context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                                return 0;
                            }

                            var playerContext = PlaceholderContext.of(player);
                            item.method_57379(class_9334.field_49631, Format.parse(itemName, playerContext));

                            context.getSource().method_9226(() -> module.locale().get("nameSet"), false);

                            return 1;
                        })
                );
    }
}
