package me.alexdevs.solstice.modules.item.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.item.ItemModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import java.util.List;

public class MoreCommand extends ModCommand<ItemModule> {
    public MoreCommand(ItemModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("more", "stack");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("more", 2))
                .executes(context -> {
                    var player = context.getSource().method_9207();
                    var item = player.method_6047();

                    if(item.method_7960()) {
                        context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                        return 0;
                    }

                    item.method_7939(item.method_7914());

                    context.getSource().method_9226(() -> module.locale().get("stackRefilled"), false);

                    return 1;
                });
    }
}
