package me.alexdevs.solstice.modules.item.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.item.ItemModule;
import net.minecraft.class_2168;
import net.minecraft.class_9334;
import java.util.List;

import static net.minecraft.class_2170.method_9247;


public class RepairCommand extends ModCommand<ItemModule> {
    public RepairCommand(ItemModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("repair", "repairitem");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("repair", 2))
                .executes(context -> {
                    var player = context.getSource().method_9207();

                    var item = player.method_6047();

                    if(item.method_7960()) {
                        context.getSource().method_9226(() -> module.locale().get("noItem"), false);
                        return 0;
                    }

                    if(!item.method_7963()) {
                        context.getSource().method_9226(() -> module.locale().get("notRepairable"), false);
                        return 0;
                    }

                    if(item.method_7986()) {
                        // Removes the NBT tag altogether instead of just setting it to 0
                        item.method_57381(class_9334.field_49629);
                        context.getSource().method_9226(() -> module.locale().get("repaired"), false);
                        return 1;
                    } else {
                        context.getSource().method_9226(() -> module.locale().get("alreadyRepaired"), false);
                        return 0;
                    }
                });
    }
}
