package me.alexdevs.solstice.modules.jail.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.data.CorePlayerData;
import me.alexdevs.solstice.modules.jail.JailModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class JailCommand extends ModCommand<JailModule> {
    public JailCommand(JailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("jail");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("jail", 2))
                .then(class_2170.method_9244("user", StringArgumentType.word())
                        .suggests(LocalGameProfile::suggest)
                        .then(class_2170.method_9244("jail", StringArgumentType.word())
                                .suggests(this::suggestJails)
                                .executes(context -> execute(context, 0, null))
                                .then(class_2170.method_9244("duration", TimeSpan.timeSpan())
                                        .suggests(TimeSpan::suggest)
                                        .executes(context -> execute(context, TimeSpan.getTimeSpan(context, "duration"), null))
                                        .then(class_2170.method_9244("reason", StringArgumentType.greedyString())
                                                .executes(context -> execute(context, TimeSpan.getTimeSpan(context, "duration"), StringArgumentType.getString(context, "reason")))
                                        )
                                )
                        )
                );
    }

    private int execute(CommandContext<class_2168> context, int seconds, @Nullable String reason) throws CommandSyntaxException {
        var source = context.getSource();
        var profile = LocalGameProfile.getProfile(context, "user");

        var data = module.getPlayer(profile.getId());
        var coreData = Solstice.playerData.get(profile.getId()).getData(CorePlayerData.class);

        if (data.jailed) {
            source.method_9226(() -> module.locale().get("alreadyJailed"), false);
            return 0;
        }

        var jailName = StringArgumentType.getString(context, "jail");

        var jails = module.getJails();
        if (!jails.containsKey(jailName)) {
            source.method_9226(() -> module.locale().get("jailNotFound"), false);
            return 0;
        }

        Permissions.check(profile, getPermissionNode("exempt")).thenAccept(granted -> {
            if (granted) {
                source.method_9226(() -> module.locale().get("playerExempt"), false);
                return;
            }

            var player = source.method_9211().method_3760().method_14602(profile.getId());

            data.jailed = true;
            data.jailedBy = source.method_43737() ? source.method_44023().method_5667() : new UUID(0L, 0L);
            data.jailedOn = new Date();
            data.jailName = jailName;
            data.jailTime = seconds;
            data.jailReason = reason;

            if (player != null) {
                data.previousLocation = new ServerLocation(player);
            } else {
                data.previousLocation = coreData.logoffPosition;
            }

            var map = Map.of(
                    "player", class_2561.method_30163(profile.getName()),
                    "jail", class_2561.method_30163(jailName),
                    "duration", class_2561.method_30163(TimeSpan.toLongString(seconds)),
                    "reason", class_2561.method_30163(reason)
            );

            class_2561 text;
            if (seconds > 0) {
                if (reason != null) {
                    text = module.locale().get("jailedForWithReason", map);
                } else {
                    text = module.locale().get("jailedFor", map);
                }
            } else {
                text = module.locale().get("jailed", map);
            }

            source.method_9226(() -> text, true);

            if (player != null) {
                module.sendToJail(player);
            }
        });

        return 1;
    }

    private CompletableFuture<Suggestions> suggestJails(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        var jails = module.getJails().keySet().stream();
        return class_2172.method_9264(jails, builder);
    }
}
