package me.alexdevs.solstice.modules.jail.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.jail.JailModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class JailsCommand extends ModCommand<JailModule> {
    public JailsCommand(JailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("jails");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(2))
                .executes(this::listJails)
                .then(class_2170.method_9247("set")
                        .requires(require("set", 3))
                        .then(class_2170.method_9244("name", StringArgumentType.word())
                                .executes(this::createJail)
                        ))
                .then(class_2170.method_9247("delete")
                        .requires(require("set", 3))
                        .then(class_2170.method_9244("name", StringArgumentType.word())
                                .suggests(this::suggestJails)
                                .executes(this::deleteJail)
                        ))
                .then(class_2170.method_9247("tp")
                        .requires(require("tp", 2))
                        .then(class_2170.method_9244("name", StringArgumentType.word())
                                .suggests(this::suggestJails)
                                .executes(this::teleport)
                        ));
    }

    private CompletableFuture<Suggestions> suggestJails(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        var jails = module.getJails().keySet().stream();
        return class_2172.method_9264(jails, builder);
    }

    private int listJails(CommandContext<class_2168> context) {
        var jails = module.getJails().keySet().stream().toList();

        if(jails.isEmpty()) {
            context.getSource().method_9226(() -> module.locale().get("noJails"), false);
            return 0;
        }

        var comma = module.locale().get("comma");
        var list = class_2561.method_43473();

        for(var i = 0; i < jails.size(); i++) {
            if(i > 0) {
                list.method_10852(comma);
            }

            list.method_10852(module.locale().get("listEntry", Map.of(
                    "jail", class_2561.method_30163(jails.get(i))
            )));
        }

        context.getSource().method_9226(() -> module.locale().get("jailList", Map.of(
                "list", list
        )), false);

        return 1;
    }

    private int createJail(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var jailName = StringArgumentType.getString(context, "name");

        var position = new ServerLocation(player);

        var jails = module.getJails();
        if (jails.containsKey(jailName)) {
            context.getSource().method_9226(() -> module.locale().get("jailAlreadyExists"), false);
            return 0;
        }

        jails.put(jailName, position);

        var map = Map.of(
                "jail", class_2561.method_30163(jailName)
        );
        context.getSource().method_9226(() -> module.locale().get("created", map), true);

        return 1;
    }

    private int deleteJail(CommandContext<class_2168> context) {
        var jailName = StringArgumentType.getString(context, "name");

        var jails = module.getJails();
        if (!jails.containsKey(jailName)) {
            context.getSource().method_9226(() -> module.locale().get("jailNotFound"), false);
            return 0;
        }

        jails.remove(jailName);

        var map = Map.of(
                "jail", class_2561.method_30163(jailName)
        );
        context.getSource().method_9226(() -> module.locale().get("deleted", map), true);

        return 1;
    }

    private int teleport(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var jailName = StringArgumentType.getString(context, "name");
        var jails = module.getJails();
        if(!jails.containsKey(jailName)) {
            context.getSource().method_9226(() -> module.locale().get("jailNotFound"), false);
            return 0;
        }

        var jail = jails.get(jailName);

        var map = Map.of(
                "jail", class_2561.method_30163(jailName)
        );

        context.getSource().method_9226(() -> module.locale().get("teleporting", map), true);

        jail.teleport(player);

        return 1;
    }
}
