package me.alexdevs.solstice.modules.kit.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.modules.kit.Utils;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class Kit {
    /**
     * itemStacks nbt is serialized and deserialized
     */
    public List<String> itemStacks = new ArrayList<>();
    public boolean oneTime = false;
    public int cooldownSeconds = 0;
    public boolean firstJoin = false;
    public @Nullable String icon;

    public List<class_1799> getItemStacks() {
        var stacks = new ArrayList<class_1799>();

        for (var stackNbt : itemStacks) {
            try {
                stacks.add(Utils.deserializeItemStack(stackNbt));
            } catch (CommandSyntaxException e) {
                Solstice.LOGGER.error("Could not load item from kit", e);
            }
        }

        return stacks;
    }

    public class_1799 getIcon() {
        var defaultStack = class_1802.field_8831.method_7854();
        if (icon == null) {
            return defaultStack;
        }
        try {
            return Utils.deserializeItemStack(icon);
        } catch (CommandSyntaxException e) {
            return defaultStack;
        }
    }
}
