package me.alexdevs.solstice.modules.miscellaneous.commands;

import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.miscellaneous.MiscellaneousModule;
import net.minecraft.class_1322;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import java.util.List;
import java.util.Map;

public class SpeedCommand extends ModCommand<MiscellaneousModule> {
    public SpeedCommand(MiscellaneousModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("speed");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require("speed.base", 2))
                .executes(context -> {
                    var player = context.getSource().method_9207();

                    if (player.method_31549().field_7479) {
                        return setFlyingSpeed(context, 1);
                    } else {
                        return setWalkingSpeed(context, 1);
                    }
                })
                .then(class_2170.method_9244("speed", FloatArgumentType.floatArg(0))
                        .executes(context -> {
                            var player = context.getSource().method_9207();
                            var speedMultiplier = FloatArgumentType.getFloat(context, "speed");
                            if (player.method_31549().field_7479) {
                                return setFlyingSpeed(context, speedMultiplier);
                            } else {
                                return setWalkingSpeed(context, speedMultiplier);
                            }
                        }))

                .then(class_2170.method_9247("walk")
                        .executes(context -> this.setWalkingSpeed(context, 1))
                        .then(class_2170.method_9244("speed", FloatArgumentType.floatArg(0))
                                .executes(context -> this.setWalkingSpeed(context, FloatArgumentType.getFloat(context, "speed"))))
                )
                .then(class_2170.method_9247("fly")
                        .executes(context -> this.setFlyingSpeed(context, 1))
                        .then(class_2170.method_9244("speed", FloatArgumentType.floatArg(0))
                                .executes(context -> this.setFlyingSpeed(context, FloatArgumentType.getFloat(context, "speed"))))
                );
    }

    private int setWalkingSpeed(CommandContext<class_2168> context, float speedMultiplier) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var attributes = player.method_6127();
        var instance = attributes.method_45329(class_5134.field_23719);
        var id = Solstice.ID.method_45136("walking_speed_multiplier");

        var map = Map.of(
                "speed", class_2561.method_30163(String.valueOf(speedMultiplier))
        );
        if (speedMultiplier == 1) {
            instance.method_6200(id);

            context.getSource().method_9226(() -> module.locale().get("walkSpeedReset", map), true);
        } else {
            var modifier = new class_1322(id, speedMultiplier, class_1322.class_1323.field_6330);
            instance.method_55696(modifier);

            context.getSource().method_9226(() -> module.locale().get("walkSpeedSet", map), true);
        }

        return 1;
    }

    private int setFlyingSpeed(CommandContext<class_2168> context, float speedMultiplier) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var abilities = player.method_31549();
        abilities.method_7248(MiscellaneousModule.DEFAULT_FLY_SPEED * speedMultiplier);
        player.method_7355();

        var map = Map.of(
                "speed", class_2561.method_30163(String.valueOf(speedMultiplier))
        );

        if (speedMultiplier == 1) {
            context.getSource().method_9226(() -> module.locale().get("flySpeedReset", map), true);
        } else {
            context.getSource().method_9226(() -> module.locale().get("flySpeedSet", map), true);
        }

        return 1;
    }
}
