package me.alexdevs.solstice.modules.near.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.near.NearModule;
import me.alexdevs.solstice.modules.near.data.NearConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class NearCommand extends ModCommand<NearModule> {
    public NearCommand(NearModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("near");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .executes(context -> execute(context, Solstice.configManager.getData(NearConfig.class).defaultRange, context.getSource().method_9207()))
                .then(method_9244("range", IntegerArgumentType.integer(0, Solstice.configManager.getData(NearConfig.class).maxRange))
                        .executes(context -> execute(context, IntegerArgumentType.getInteger(context, "range"), context.getSource().method_9207())));
    }

    private int execute(CommandContext<class_2168> context, int range, class_3222 sourcePlayer) {
        var playerContext = PlaceholderContext.of(sourcePlayer);
        var list = new ArrayList<ClosePlayers>();

        var sourcePos = sourcePlayer.method_19538();
        sourcePlayer.method_51469().method_18456().forEach(targetPlayer -> {
            var targetPos = targetPlayer.method_19538();
            if (!sourcePlayer.method_5667().equals(targetPlayer.method_5667()) && sourcePos.method_24802(targetPos, range)) {
                var distance = sourcePos.method_1022(targetPos);
                list.add(new ClosePlayers(targetPlayer, distance));
            }
        });

        if (list.isEmpty()) {
            context.getSource().method_9226(() -> module.locale().get(
                    "noOne",
                    playerContext
            ), false);
            return 1;
        }

        list.sort(Comparator.comparingDouble(ClosePlayers::distance));

        var listText = class_2561.method_43473();
        var comma = module.locale().get("comma");
        for (int i = 0; i < list.size(); i++) {
            var player = list.get(i);
            if (i > 0) {
                listText = listText.method_10852(comma);
            }
            var placeholders = Map.of(
                    "player", player.player.method_5476(),
                    "distance", class_2561.method_30163(String.format("%.1fm", player.distance))
            );

            var targetContext = PlaceholderContext.of(sourcePlayer);

            listText = listText.method_10852(module.locale().get(
                    "format",
                    targetContext,
                    placeholders
            ));
        }

        var placeholders = Map.of(
                "playerList", (class_2561) listText
        );
        context.getSource().method_9226(() -> module.locale().get(
                "nearestPlayers",
                playerContext,
                placeholders
        ), false);

        return 1;
    }

    private record ClosePlayers(class_3222 player, double distance) {
    }
}
