package me.alexdevs.solstice.modules.notifications;

import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.afk.AfkModule;
import me.alexdevs.solstice.modules.notifications.commands.NotificationsCommand;
import me.alexdevs.solstice.modules.notifications.data.NotificationsConfig;
import me.alexdevs.solstice.modules.notifications.data.NotificationsLocale;
import me.alexdevs.solstice.modules.notifications.data.NotificationsPlayerData;
import me.alexdevs.solstice.modules.notifications.data.PlayerNotificationSettings;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class NotificationsModule extends ModuleBase.Toggleable {
    private static NotificationsModule instance;
    public NotificationsModule(class_2960 id) {
        super(id);
        instance = this;
    }

    @Override
    public void init() {
        registerConfig(NotificationsConfig.class, NotificationsConfig::new);
        registerLocale(NotificationsLocale.MODULE);
        registerPlayerData(NotificationsPlayerData.class, NotificationsPlayerData::new);

        commands.add(new NotificationsCommand(this));

        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, parameters) -> {
            var content = message.method_46291().getString().toLowerCase();

            sender.method_5682().method_3760().method_14571().forEach(player -> {
                if (player.equals(sender)) {
                    return;
                }

                var playerName = player.method_7334().getName().toLowerCase();
                if (content.contains(playerName)) {
                    var settings = getPlayerSettings(player);
                    if (settings.onChat()) {
                        notifyPlayer(player);
                    }
                }
            });
        });
    }

    public static void notify(class_3222 player) {
        if (!instance.isEnabled())
            return;

        instance.notifyPlayer(player);
    }

    public NotificationsConfig getConfig() {
        return Solstice.configManager.getData(NotificationsConfig.class);
    }

    public NotificationsPlayerData getPlayerData(class_3222 player) {
        return Solstice.playerData.get(player).getData(NotificationsPlayerData.class);
    }

    public PlayerNotificationSettings getPlayerSettings(class_3222 player) {
        var data = getPlayerData(player);
        var config = getConfig();

        return new PlayerNotificationSettings(
                data.soundId != null ? data.soundId : config.defaultValues.soundId,
                data.pitch != null ? data.pitch : config.defaultValues.pitch,
                data.volume != null ? data.volume : config.defaultValues.volume,
                data.afkOnly != null ? data.afkOnly : config.defaultValues.afkOnly,
                data.onChat != null ? data.onChat : config.defaultValues.onChat
        );
    }

    public boolean shouldNotify(class_3222 player) {
        if (!isEnabled())
            return false;

        var data = getPlayerData(player);
        var settings = getPlayerSettings(player);

        if (!data.enable)
            return false;

        var afkModule = ModuleProvider.AFK;
        if (afkModule.isEnabled()) {
            return afkModule.isPlayerAfk(player) || !settings.afkOnly();
        }

        return true;
    }

    public void notifyPlayer(class_3222 player) {
        if (!shouldNotify(player))
            return;

        var settings = getPlayerSettings(player);
        var id = class_2960.method_12829(settings.soundId());
        if (id == null) {
            return;
        }

        player.method_17356(class_3414.method_47908(id), class_3419.field_15250, settings.volume(), settings.pitch());
    }
}
