package me.alexdevs.solstice.modules.notifications.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.notifications.NotificationsModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

public class NotificationsCommand extends ModCommand<NotificationsModule> {

    public NotificationsCommand(NotificationsModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("notifications");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(true))
                .then(class_2170.method_9247("set")
                        .then(class_2170.method_9247("sound")
                                .then(class_2170.method_9244("sound", class_2232.method_9441())
                                        .suggests(class_2321.field_10934)
                                        .executes(this::setSound)
                                )
                        )
                        .then(class_2170.method_9247("pitch")
                                .then(class_2170.method_9244("pitch", FloatArgumentType.floatArg(0f, 2f))
                                        .executes(this::setPitch)
                                )
                        )
                        .then(class_2170.method_9247("volume")
                                .then(class_2170.method_9244("volume", IntegerArgumentType.integer(0, 200))
                                        .executes(this::setVolume)
                                )
                        )
                        .then(class_2170.method_9247("afk-only")
                                .then(class_2170.method_9244("afk-only", BoolArgumentType.bool())
                                        .executes(this::setAfkOnly)
                                )
                        )
                        .then(class_2170.method_9247("on-chat")
                                .then(class_2170.method_9244("on-chat", BoolArgumentType.bool())
                                        .executes(this::setOnChat)
                                )
                        )
                )
                .then(class_2170.method_9247("get")
                        .executes(this::getSettings))
                .then(class_2170.method_9247("toggle")
                        .executes(this::toggle))
                .then(class_2170.method_9247("reset")
                        .executes(this::reset));
    }

    private int setSound(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var soundId = class_2232.method_9443(context, "sound");

        var data = module.getPlayerData(player);
        data.soundId = soundId.toString();

        var map = Map.of(
                "sound", class_2561.method_30163(soundId.toString())
        );
        context.getSource().method_9226(() -> module.locale().get("setSound", map), false);

        return 1;
    }

    private int setPitch(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var pitch = FloatArgumentType.getFloat(context, "pitch");

        var data = module.getPlayerData(player);
        data.pitch = pitch;

        var map = Map.of(
                "pitch", class_2561.method_30163(String.valueOf(pitch))
        );
        context.getSource().method_9226(() -> module.locale().get("setPitch", map), false);

        return 1;
    }

    private int setVolume(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var volume = IntegerArgumentType.getInteger(context, "volume");

        var data = module.getPlayerData(player);
        data.volume = volume / 100f;

        var map = Map.of(
                "volume", class_2561.method_30163(volume + "%")
        );
        context.getSource().method_9226(() -> module.locale().get("setVolume", map), false);

        return 1;
    }

    private int setAfkOnly(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var afkOnly = BoolArgumentType.getBool(context, "afk-only");

        var data = module.getPlayerData(player);
        data.afkOnly = afkOnly;

        if (afkOnly) {
            context.getSource().method_9226(() -> module.locale().get("setAfkOnlyEnabled"), false);
        } else {
            context.getSource().method_9226(() -> module.locale().get("setAfkOnlyDisabled"), false);
        }

        return 1;
    }

    private int setOnChat(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var onChat = BoolArgumentType.getBool(context, "on-chat");

        var data = module.getPlayerData(player);
        data.onChat = onChat;

        if (onChat) {
            context.getSource().method_9226(() -> module.locale().get("setOnChatEnabled"), false);
        } else {
            context.getSource().method_9226(() -> module.locale().get("setOnChatDisabled"), false);
        }

        return 1;
    }

    private int getSettings(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var data = module.getPlayerData(player);
        var settings = module.getPlayerSettings(player);

        var map = Map.of(
                "sound", class_2561.method_30163(settings.soundId()),
                "pitch", class_2561.method_30163(String.valueOf(settings.pitch())),
                "volume", class_2561.method_30163(settings.volume() * 100 + "%")
        );

        var text = class_2561.method_43473();
        text.method_10852(module.locale().get("getHeader"));
        text.method_27693("\n");

        text.method_10852(module.locale().get(data.enable ? "getEnabled.true" : "getEnabled.false"));
        text.method_27693("\n");
        text.method_10852(module.locale().get("getSound", map));
        text.method_27693("\n");
        text.method_10852(module.locale().get("getPitch", map));
        text.method_27693("\n");
        text.method_10852(module.locale().get("getVolume", map));
        text.method_27693("\n");
        text.method_10852(module.locale().get(settings.afkOnly() ? "getAfkOnly.true" : "getAfkOnly.false"));
        text.method_27693("\n");
        text.method_10852(module.locale().get(settings.onChat() ? "getOnChat.true" : "getOnChat.false"));

        context.getSource().method_9226(() -> text, false);

        return 1;
    }

    private int toggle(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var data = module.getPlayerData(player);
        data.enable = !data.enable;

        if (data.enable) {
            context.getSource().method_9226(() -> module.locale().get("toggleEnabled"), false);
        } else {
            context.getSource().method_9226(() -> module.locale().get("toggleDisabled"), false);
        }

        return 1;
    }

    private int reset(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();

        var data = module.getPlayerData(player);
        data.soundId = null;
        data.pitch = null;
        data.volume = null;
        data.afkOnly = null;

        context.getSource().method_9226(() -> module.locale().get("reset"), false);

        return 1;
    }
}
