package me.alexdevs.solstice.modules.powertool.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.powertool.Action;
import me.alexdevs.solstice.modules.powertool.PowerToolModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PowerToolCommand extends ModCommand<PowerToolModule> {
    public PowerToolCommand(PowerToolModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("powertool", "pt");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return class_2170.method_9247(name)
                .requires(require(2))
                .then(class_2170.method_9247("set")
                        .then(class_2170.method_9244("action", StringArgumentType.word())
                                .suggests((context, builder) -> class_2172.method_9253(Action.stringValues(), builder))
                                .then(class_2170.method_9244("command", StringArgumentType.greedyString())
                                        .executes(context -> {
                                            var player = context.getSource().method_9207();
                                            var actionName = StringArgumentType.getString(context, "action");
                                            var command = StringArgumentType.getString(context, "command");

                                            var action = Action.valueOf(actionName.toUpperCase());

                                            var hand = player.method_6058();
                                            var item = player.method_5998(hand);

                                            if (item.method_7960()) {
                                                context.getSource().method_9226(() -> module.locale().get("emptyHand"), false);
                                                return 0;
                                            }

                                            var data = module.getData(player.method_5667());

                                            var itemId = module.getStackId(item);

                                            var powerTool = data.powerTools.computeIfAbsent(itemId, s -> new HashMap<>());
                                            powerTool.put(action, command);

                                            var map = Map.of(
                                                    "item", class_2561.method_30163(itemId),
                                                    "action", class_2561.method_30163(actionName),
                                                    "command", class_2561.method_30163(command)
                                            );

                                            context.getSource().method_9226(() -> module.locale().get("actionSet", map), false);

                                            return 1;
                                        })
                                )
                        ))
                .then(class_2170.method_9247("clear")
                        .then(class_2170.method_9244("action", StringArgumentType.word())
                                .suggests((context, builder) -> class_2172.method_9253(Action.stringValues(), builder))
                                .executes(context -> {
                                    var player = context.getSource().method_9207();
                                    var actionName = StringArgumentType.getString(context, "action");

                                    var action = Action.valueOf(actionName.toUpperCase());

                                    var hand = player.method_6058();
                                    var item = player.method_5998(hand);

                                    if (item.method_7960()) {
                                        context.getSource().method_9226(() -> module.locale().get("emptyHand"), false);
                                        return 0;
                                    }

                                    var data = module.getData(player.method_5667());

                                    var itemId = module.getStackId(item);

                                    var map = Map.of(
                                            "item", class_2561.method_30163(itemId),
                                            "action", class_2561.method_30163(actionName)
                                    );

                                    if(!data.powerTools.containsKey(itemId)) {
                                        context.getSource().method_9226(() -> module.locale().get("noAction", map), false);
                                        return 0;
                                    }

                                    data.powerTools.get(itemId).remove(action);

                                    context.getSource().method_9226(() -> module.locale().get("actionCleared", map), false);

                                    return 1;
                                })
                        )
                        .executes(context -> {
                            var player = context.getSource().method_9207();

                            var hand = player.method_6058();
                            var item = player.method_5998(hand);

                            if (item.method_7960()) {
                                context.getSource().method_9226(() -> module.locale().get("emptyHand"), false);
                                return 0;
                            }

                            var data = module.getData(player.method_5667());

                            var itemId = module.getStackId(item);

                            data.powerTools.remove(itemId);

                            var map = Map.of(
                                    "item", class_2561.method_30163(itemId)
                            );

                            context.getSource().method_9226(() -> module.locale().get("allCleared", map), false);

                            return 1;
                        })
                )
                .then(class_2170.method_9247("check")
                        .executes(context -> {
                            var player = context.getSource().method_9207();

                            var hand = player.method_6058();
                            var item = player.method_5998(hand);

                            if (item.method_7960()) {
                                context.getSource().method_9226(() -> module.locale().get("emptyHand"), false);
                                return 0;
                            }

                            var data = module.getData(player.method_5667());

                            var itemId = module.getStackId(item);

                            var powertool = data.powerTools.getOrDefault(itemId, Map.of());

                            var itemMap = Map.of(
                                    "item", class_2561.method_30163(itemId)
                            );

                            var text = class_2561.method_43473();
                            text.method_10852(module.locale().get("check", itemMap));

                            for(var action : Action.values()) {
                                text.method_27693("\n");

                                if(powertool.containsKey(action)) {
                                    var map = Map.of(
                                            "item", class_2561.method_30163(itemId),
                                            "action", class_2561.method_30163(action.method_15434()),
                                            "command", class_2561.method_30163(powertool.get(action))
                                    );
                                    text.method_10852(module.locale().get("checkEntry", map));
                                } else {
                                    var map = Map.of(
                                            "item", class_2561.method_30163(itemId),
                                            "action", class_2561.method_30163(action.method_15434())
                                    );
                                    text.method_10852(module.locale().get("checkEntryNotSet", map));
                                }
                            }

                            context.getSource().method_9226(() -> text, false);

                            return 1;
                        }));
    }
}
