package me.alexdevs.solstice.modules.staffChat;

import eu.pb4.placeholders.api.node.TextNode;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.parser.MarkdownParser;
import me.alexdevs.solstice.modules.staffChat.commands.StaffChatCommand;
import me.alexdevs.solstice.modules.staffChat.data.StaffChatLocale;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
public class StaffChatModule extends ModuleBase.Toggleable {
    
    private final ConcurrentHashMap<UUID, Boolean> stickyStaffChat = new ConcurrentHashMap<>();

    public StaffChatModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        registerLocale(StaffChatLocale.MODULE);

        commands.add(new StaffChatCommand(this));

        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, player, pars) -> {
            if (stickyStaffChat.getOrDefault(player.method_5667(), false)
                    && canUseStaffChat(player)) {

                sendStaffChatMessage(player.method_5476(), message.method_46291());

                return false;
            }
            return true;
        });
    }

    public boolean canUseStaffChat(class_3222 player) {
        return Permissions.check(player, getPermissionNode("base"), 1);
    }

    public void sendStaffChatMessage(class_2561 sourceName, final class_2561 message) {
        var formattedMessage = MarkdownParser.defaultParser.parseNode(TextNode.convert(message)).toText();


        var text = locale().get("message", Map.of(
                "name", sourceName,
                "message", formattedMessage
        ));

        Solstice.server.method_43496(text);
        Solstice.server.method_3760().method_14571().forEach(player -> {
            if (canUseStaffChat(player)) {
                player.method_7353(text, false);
            }
        });
    }

    public boolean toggleStaffChat(UUID uuid) {
        var val = !stickyStaffChat.getOrDefault(uuid, false);
        stickyStaffChat.put(uuid, val);
        return val;
    }
}
