package me.alexdevs.solstice.modules.teleportHere.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.teleportHere.TeleportHereModule;
import net.minecraft.class_1314;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Set;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportHereCommand extends ModCommand<TeleportHereModule> {
    public TeleportHereCommand(TeleportHereModule module) {
        super(module);
    }

    public List<String> getNames() {
        return List.of("tphere");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(2))
                .then(method_9244("targets", class_2186.method_9306())
                        .executes(context -> {
                            var source = context.getSource();
                            var player = source.method_9207();
                            var world = player.method_51469();
                            var vec3d = player.method_19538();
                            var yaw = player.method_36454();
                            var pitch = player.method_36455();

                            var targets = class_2186.method_9317(context, "targets");

                            targets.forEach(target -> {
                                target.method_48105(world, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, Set.of(), yaw, pitch);
                                target.method_18799(target.method_18798().method_18805(1.0, 0.0, 1.0));
                                target.method_24830(true);

                                if (target instanceof class_1314 pathAwareEntity) {
                                    pathAwareEntity.method_5942().method_6340();
                                }
                            });

                            if (targets.size() == 1) {
                                source.method_9226(() -> class_2561.method_43469("commands.teleport.success.entity.single", targets.iterator().next().method_5476(), player.method_5476()), true);
                            } else {
                                source.method_9226(() -> class_2561.method_43469("commands.teleport.success.entity.multiple", targets.size(), player.method_5476()), true);
                            }

                            return targets.size();
                        }));
    }
}
