package me.alexdevs.solstice.modules.teleportRequest.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.ignore.IgnoreModule;
import me.alexdevs.solstice.modules.teleportRequest.TeleportRequestModule;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import java.util.List;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TeleportAskCommand extends ModCommand<TeleportRequestModule> {
    public TeleportAskCommand(TeleportRequestModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("tpa", "tpask");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require("ask", true))
                .then(method_9244("player", class_2186.method_9305())
                        .executes(this::execute));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var target = class_2186.method_9315(context, "player");

        var ignoreModule = ModuleProvider.IGNORE;
        if (ignoreModule.isEnabled() && ignoreModule.getPlayerData(target.method_5667()).ignoredPlayers.contains(player.method_5667())) {
            return 0;
        }

        module.requestTo(player, target);

        return 1;
    }
}
