package me.alexdevs.solstice.modules.timeBar.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.events.TimeBarEvents;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.timeBar.TimeBarModule;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5242;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class TimeBarCommand extends ModCommand<TimeBarModule> {
    private static final ConcurrentHashMap<UUID, BarCommand> runningBars = new ConcurrentHashMap<>();

    public TimeBarCommand(TimeBarModule module) {
        super(module);

        TimeBarEvents.END.register((timeBar, server) -> {
            if (runningBars.containsKey(timeBar.getUuid())) {
                var barCommand = runningBars.get(timeBar.getUuid());
                final var command = barCommand.command();
                final var source = barCommand.source();
                runningBars.remove(timeBar.getUuid());
                Solstice.nextTick(() -> {
                    try {
                        dispatcher.execute(command, source);
                    } catch (CommandSyntaxException e) {
                        source.method_9226(() -> class_2561.method_43470(e.toString()).method_27692(class_124.field_1061), false);
                    }
                });
            }
        });
    }

    @Override
    public List<String> getNames() {
        return List.of("timebar");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(3))
                .then(method_9247("start")
                        .then(method_9244("duration", StringArgumentType.word())
                                .suggests(TimeSpan::suggest)
                                .then(method_9244("color", StringArgumentType.word())
                                        .suggests((context, builder) -> {
                                            var colors = Arrays.stream(class_1259.class_1260.values()).map(Enum::toString).toList();
                                            return class_2172.method_9265(colors, builder);
                                        })
                                        .then(method_9244("style", StringArgumentType.word())
                                                .suggests((context, builder) -> {
                                                    var styles = Arrays.stream(class_1259.class_1261.values()).map(Enum::toString).toList();
                                                    return class_2172.method_9265(styles, builder);
                                                })
                                                .then(method_9244("countdown", BoolArgumentType.bool())
                                                        .then(method_9244("label", StringArgumentType.string())
                                                                .then(method_9244("command", StringArgumentType.greedyString())
                                                                        .suggests((context, builder) -> dispatcher.getRoot().listSuggestions(context, builder))
                                                                        .executes(this::execute))

                                                        )
                                                )
                                        )
                                )
                        )
                )
                .then(method_9247("cancel")
                        .then(method_9244("uuid", class_5242.method_27643())
                                .executes(this::executeCancel)));
    }

    private int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        var seconds = TimeSpan.getTimeSpan(context, "duration");
        var colorName = StringArgumentType.getString(context, "color");
        var styleName = StringArgumentType.getString(context, "style");
        var countdown = BoolArgumentType.getBool(context, "countdown");
        var label = StringArgumentType.getString(context, "label");
        var command = StringArgumentType.getString(context, "command");

        var color = class_1259.class_1260.valueOf(colorName);
        var style = class_1259.class_1261.valueOf(styleName);

        var bar = module.startTimeBar(label, seconds, color, style, countdown);

        runningBars.put(bar.getUuid(), new BarCommand(context.getSource(), command));

        context.getSource().method_9226(() -> class_2561
                .method_43470("New time bar created with UUID ")
                .method_10852(class_2561.method_43470(bar.getUuid().toString()).method_10862(class_2583.field_24360
                        .method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_30163("Click to copy")))
                        .method_10958(new class_2558(class_2558.class_2559.field_21462, bar.getUuid().toString())))), true);

        return 1;
    }

    private int executeCancel(CommandContext<class_2168> context) {
        var uuid = class_5242.method_27645(context, "uuid");

        if (!runningBars.containsKey(uuid)) {
            context.getSource().method_9226(() -> class_2561.method_43470("Time bar not found!").method_27692(class_124.field_1061), false);
            return 1;
        }

        runningBars.remove(uuid);
        module.cancelTimeBar(uuid);

        context.getSource().method_9226(() -> class_2561.method_43470("Time bar canceled"), true);

        return 1;
    }

    private record BarCommand(class_2168 source, String command) {
    }
}
