package me.alexdevs.solstice.modules.warp.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.warp.WarpModule;
import me.alexdevs.solstice.modules.warp.data.WarpServerData;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class WarpCommand extends ModCommand<WarpModule> {
    public WarpCommand(WarpModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("warp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return method_9247(name)
                .requires(require(true))
                .then(method_9244("name", StringArgumentType.word())
                        .suggests((context, builder) -> {
                            var player = context.getSource().method_9207();
                            var serverData = Solstice.serverData.getData(WarpServerData.class);
                            var warps = serverData.warps.keySet().stream().filter(serverPosition -> module.canUseWarp(player, serverPosition)).sorted();
                            return class_2172.method_9264(warps, builder);
                        })
                        .executes(context -> execute(context, StringArgumentType.getString(context, "name"))));
    }

    private int execute(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        var player = context.getSource().method_9207();
        var serverDate = Solstice.serverData.getData(WarpServerData.class);
        var warps = serverDate.warps;
        var playerContext = PlaceholderContext.of(player);

        var placeholders = Map.of(
                "warp", class_2561.method_30163(name)
        );

        if (!warps.containsKey(name)) {
            context.getSource().method_9226(() -> module.locale().get(
                    "warpNotFound",
                    playerContext,
                    placeholders

            ), false);
            return 0;
        }

        if (!module.canUseWarp(player, name)) {
            context.getSource().method_9226(() -> module.locale().get(
                    "noPermission",
                    playerContext,
                    placeholders
            ), false);

            return 0;
        }

        context.getSource().method_9226(() -> module.locale().get(
                "teleporting",
                playerContext,
                placeholders
        ), false);

        var warpPosition = warps.get(name);
        warpPosition.teleport(player);

        return 1;
    }
}
