/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice;

import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.alexdevs.solstice.Paths;
import me.alexdevs.solstice.api.config.ConfigDataManager;
import me.alexdevs.solstice.api.config.IConfigDataManager;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.events.WorldSaveCallback;
import me.alexdevs.solstice.core.Modules;
import me.alexdevs.solstice.core.Scheduler;
import me.alexdevs.solstice.core.ToggleableConfig;
import me.alexdevs.solstice.core.UserCache;
import me.alexdevs.solstice.core.WarmUpManager;
import me.alexdevs.solstice.data.PlayerDataManager;
import me.alexdevs.solstice.data.ServerData;
import me.alexdevs.solstice.integrations.ConnectorIntegration;
import me.alexdevs.solstice.integrations.LuckPermsIntegration;
import me.alexdevs.solstice.locale.LocaleManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.configurate.ConfigurateException;

public class Solstice
implements ModInitializer {
    public static final String MOD_ID = "solstice";
    public static final Logger LOGGER = LoggerFactory.getLogger(Solstice.class);
    public static final class_2960 ID = class_2960.method_60655((String)"solstice", (String)"");
    public static final IConfigDataManager configManager = new ConfigDataManager(Paths.configDirectory.resolve("config.conf"));
    public static final LocaleManager localeManager = new LocaleManager(Paths.configDirectory.resolve("locale.json"));
    public static final ServerData serverData = new ServerData();
    public static final PlayerDataManager playerData = new PlayerDataManager();
    public static final Modules modules = new Modules();
    private static final ConcurrentLinkedQueue<Runnable> nextTickRunnables = new ConcurrentLinkedQueue();
    public static MinecraftServer server;
    public static Scheduler scheduler;
    public static final WarmUpManager warmUp;
    private static Solstice INSTANCE;
    private static final UserCache userCache;

    public Solstice() {
        INSTANCE = this;
    }

    public static Solstice getInstance() {
        return INSTANCE;
    }

    public static void nextTick(Runnable runnable) {
        nextTickRunnables.add(runnable);
    }

    public static UserCache getUserCache() {
        return userCache;
    }

    public void onInitialize() {
        ModMetadata modMeta = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).getMetadata();
        LOGGER.info("Initializing Solstice v{}...", (Object)modMeta.getVersion());
        ConnectorIntegration.register();
        LuckPermsIntegration.register();
        modules.register();
        modules.initModules();
        ToggleableConfig.get().save();
        try {
            configManager.load();
            configManager.save();
        }
        catch (ConfigurateException e) {
            LOGGER.error("Error while loading Solstice config! Refusing to continue!", (Throwable)e);
            return;
        }
        try {
            localeManager.load();
            localeManager.save();
        }
        catch (Exception e) {
            LOGGER.error("Error while loading Solstice locale!", (Throwable)e);
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            Solstice.server = server;
            Path path = server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_ID);
            if (!path.toFile().exists()) {
                path.toFile().mkdirs();
            }
            serverData.setDataPath(path.resolve("server.json"));
            playerData.setDataPath(path.resolve("players"));
            serverData.loadData(false);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> ((SolsticeEvents.Ready)SolsticeEvents.READY.invoker()).onReady(INSTANCE, server));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> scheduler.shutdownNow());
        WorldSaveCallback.EVENT.register((server1, suppressLogs, flush, force) -> {
            serverData.save();
            playerData.saveAll();
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            nextTickRunnables.forEach(Runnable::run);
            nextTickRunnables.clear();
        });
    }

    public void broadcast(class_2561 text) {
        server.method_3760().method_43514(text, false);
    }

    static {
        scheduler = new Scheduler(1, nextTickRunnables);
        warmUp = new WarmUpManager();
        userCache = new UserCache(FabricLoader.getInstance().getGameDir().resolve("usercache.json").toFile());
    }
}

