/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.command;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.locale.Locale;
import net.minecraft.class_2168;
import org.jetbrains.annotations.Nullable;

public class TimeSpan {
    public static final SimpleCommandExceptionType INVALID_TIMESPAN = new SimpleCommandExceptionType((Message)new LiteralMessage("Invalid timespan"));
    private static final Pattern minorTimeString = Pattern.compile("^\\d+$");
    private static final Pattern timeString = Pattern.compile("^((\\d+)w)?((\\d+)d)?((\\d+)h)?((\\d+)m)?((\\d+)s)?$");
    private static final Pattern timeStringNoEnd = Pattern.compile("^((\\d+)w)?((\\d+)d)?((\\d+)h)?((\\d+)m)?((\\d+)s)?");
    private static final Pattern lastDigits = Pattern.compile("\\d+$");
    private static final int secondsInMinute = 60;
    private static final int secondsInHour = 3600;
    private static final int secondsInDay = 86400;
    private static final int secondsInWeek = 604800;
    private static final int secondsInMonth = 2592000;
    private static final int secondsInYear = 31536000;

    private static int amount(@Nullable String g, int multiplier) {
        if (g != null && !g.isEmpty()) {
            return multiplier * Integer.parseUnsignedInt(g);
        }
        return 0;
    }

    public static String toShortString(int total) {
        StringBuilder builder = new StringBuilder();
        if (total >= 604800) {
            builder.append(total / 604800);
            builder.append("w");
            total %= 604800;
        }
        if (total >= 86400) {
            builder.append(total / 86400);
            builder.append("d");
            total %= 86400;
        }
        if (total >= 3600) {
            builder.append(total / 3600);
            builder.append("h");
            total %= 3600;
        }
        if (total >= 60) {
            builder.append(total / 60);
            builder.append("m");
            total %= 60;
        }
        if (total > 0) {
            builder.append(total);
            builder.append("s");
        }
        return builder.toString();
    }

    private static String fill(String locale, int unit) {
        return locale.replaceAll("\\$\\{n}", String.valueOf(unit));
    }

    public static String toLongString(int total) {
        int value;
        StringBuilder builder = new StringBuilder();
        Locale locale = Solstice.localeManager.getShared();
        boolean prependSpace = false;
        if (total >= 31536000) {
            value = total / 31536000;
            if (value == 1) {
                builder.append(TimeSpan.fill(locale.raw("~unit.year"), value));
            } else {
                builder.append(TimeSpan.fill(locale.raw("~unit.years"), value));
            }
            total %= 31536000;
            prependSpace = true;
        }
        if (total >= 2592000) {
            if (prependSpace) {
                builder.append(" ");
            }
            if ((value = total / 2592000) == 1) {
                builder.append(TimeSpan.fill(locale.raw("~unit.month"), value));
            } else {
                builder.append(TimeSpan.fill(locale.raw("~unit.months"), value));
            }
            total %= 2592000;
            prependSpace = true;
        }
        if (total >= 604800) {
            if (prependSpace) {
                builder.append(" ");
            }
            if ((value = total / 604800) == 1) {
                builder.append(TimeSpan.fill(locale.raw("~unit.week"), value));
            } else {
                builder.append(TimeSpan.fill(locale.raw("~unit.weeks"), value));
            }
            total %= 604800;
            prependSpace = true;
        }
        if (total >= 86400) {
            if (prependSpace) {
                builder.append(" ");
            }
            if ((value = total / 86400) == 1) {
                builder.append(TimeSpan.fill(locale.raw("~unit.day"), value));
            } else {
                builder.append(TimeSpan.fill(locale.raw("~unit.days"), value));
            }
            total %= 86400;
            prependSpace = true;
        }
        if (total >= 3600) {
            if (prependSpace) {
                builder.append(" ");
            }
            if ((value = total / 3600) == 1) {
                builder.append(TimeSpan.fill(locale.raw("~unit.hour"), value));
            } else {
                builder.append(TimeSpan.fill(locale.raw("~unit.hours"), value));
            }
            total %= 3600;
            prependSpace = true;
        }
        if (total >= 60) {
            if (prependSpace) {
                builder.append(" ");
            }
            if ((value = total / 60) == 1) {
                builder.append(TimeSpan.fill(locale.raw("~unit.minute"), value));
            } else {
                builder.append(TimeSpan.fill(locale.raw("~unit.minutes"), value));
            }
            total %= 60;
            prependSpace = true;
        }
        if (total > 0) {
            if (prependSpace) {
                builder.append(" ");
            }
            if (total == 1) {
                builder.append(TimeSpan.fill(locale.raw("~unit.second"), total));
            } else {
                builder.append(TimeSpan.fill(locale.raw("~unit.seconds"), total));
            }
        }
        return builder.toString();
    }

    public static Optional<? extends Integer> parse(String s) {
        if (minorTimeString.matcher(s).matches()) {
            return Optional.of(Integer.parseUnsignedInt(s));
        }
        Matcher m = timeString.matcher(s);
        if (m.matches()) {
            int time = TimeSpan.amount(m.group(2), 604800);
            time += TimeSpan.amount(m.group(4), 86400);
            time += TimeSpan.amount(m.group(6), 3600);
            time += TimeSpan.amount(m.group(8), 60);
            if ((time += TimeSpan.amount(m.group(10), 1)) > 0) {
                return Optional.of(time);
            }
        }
        return Optional.empty();
    }

    public static int getTimeSpan(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        String argument = (String)context.getArgument(name, String.class);
        Optional<? extends Integer> timespan = TimeSpan.parse(argument);
        if (timespan.isPresent()) {
            return timespan.get();
        }
        throw INVALID_TIMESPAN.create();
    }

    public static CompletableFuture<Suggestions> suggest(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String original = builder.getRemainingLowerCase();
        if (original.isEmpty()) {
            return Suggestions.empty();
        }
        if (timeString.matcher(original).matches()) {
            builder.suggest(original);
            return builder.buildFuture();
        }
        List<Unit> units = List.of(new Unit("w", "Week"), new Unit("d", "Day"), new Unit("h", "Hour"), new Unit("m", "Minute"), new Unit("s", "Second"));
        if (minorTimeString.matcher(original).matches()) {
            for (Unit unit : units) {
                builder.suggest(original + unit.unit, (Message)new LiteralMessage(unit.tooltip));
            }
            return builder.buildFuture();
        }
        if (timeStringNoEnd.matcher(original).find() && lastDigits.matcher(original).find()) {
            int i;
            int max = 0;
            for (i = 0; i < units.size(); ++i) {
                if (!original.contains(units.get((int)i).unit)) continue;
                max = i + 1;
            }
            for (i = max; i < units.size(); ++i) {
                Unit unit = units.get(i);
                if (original.contains(unit.unit)) continue;
                builder.suggest(original + unit.unit, (Message)new LiteralMessage(unit.tooltip));
            }
        }
        return builder.buildFuture();
    }

    public static StringArgumentType timeSpan() {
        return StringArgumentType.word();
    }

    private record Unit(String unit, String tooltip) {
    }
}

