/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.config;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.config.IConfigDataManager;
import me.alexdevs.solstice.api.config.serializers.DateSerializer;
import net.minecraft.class_2960;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.loader.HeaderMode;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

public class ConfigDataManager
implements IConfigDataManager {
    public static final int CONFIG_VERSION = 2;
    private final Map<class_2960, Class<?>> classMap = new HashMap();
    private final Map<Class<?>, Supplier<?>> defaultSuppliers = new HashMap();
    private final Map<Class<?>, Object> dataMap = new HashMap();
    private final Path filePath;
    private final HoconConfigurationLoader loader;
    private CommentedConfigurationNode root;

    public ConfigDataManager(Path filePath) {
        this.filePath = filePath;
        this.loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(filePath)).emitComments(true).prettyPrinting(true).headerMode(HeaderMode.PRESET)).defaultOptions(opts -> opts.shouldCopyDefaults(true).header("Solstice Configuration File. Consult https://solstice.alexdevs.me/ for documentation.").serializers(TypeSerializerCollection.defaults().childBuilder().registerExact((ScalarSerializer)DateSerializer.TYPE).build()))).build();
    }

    @Override
    public <T> void registerData(class_2960 id, Class<T> classOfConfig, Supplier<T> creator) {
        if (this.classMap.containsKey(id) || this.defaultSuppliers.containsKey(classOfConfig)) {
            throw new IllegalArgumentException("Config with identifier " + String.valueOf(id) + " already registered");
        }
        this.classMap.put(id, classOfConfig);
        this.defaultSuppliers.put(classOfConfig, creator);
    }

    @Override
    public <T> T getData(Class<T> classOfConfig) {
        if (!this.dataMap.containsKey(classOfConfig)) {
            if (this.defaultSuppliers.containsKey(classOfConfig)) {
                Supplier<?> creator = this.defaultSuppliers.get(classOfConfig);
                Object data = creator.get();
                this.dataMap.put(classOfConfig, data);
                return (T)data;
            }
            throw new IllegalArgumentException("Config with class " + classOfConfig.getName() + " not registered");
        }
        Object data = this.dataMap.get(classOfConfig);
        return (T)data;
    }

    private Map<String, List<Map.Entry<class_2960, Class<?>>>> getSections() {
        return this.classMap.entrySet().stream().collect(Collectors.groupingBy(entry -> ((class_2960)entry.getKey()).method_12836()));
    }

    @Override
    public void save() {
        Map<String, List<Map.Entry<class_2960, Class<?>>>> namespaces = this.getSections();
        for (Map.Entry<String, List<Map.Entry<class_2960, Class<?>>>> group : namespaces.entrySet()) {
            String namespace = group.getKey();
            CommentedConfigurationNode section = (CommentedConfigurationNode)this.root.node(new Object[]{namespace});
            for (Map.Entry<class_2960, Class<?>> entry : group.getValue()) {
                try {
                    String path = entry.getKey().method_12832();
                    Class<?> classOfConfig = this.classMap.get(entry.getKey());
                    ((CommentedConfigurationNode)section.node(new Object[]{path})).set(classOfConfig, this.dataMap.get(classOfConfig));
                }
                catch (ConfigurateException e) {
                    Solstice.LOGGER.error("Could not save configuration data for {}. Skipping", (Object)entry.getKey(), (Object)e);
                }
            }
        }
        try {
            this.loader.save((ConfigurationNode)this.root);
        }
        catch (ConfigurateException e) {
            Solstice.LOGGER.error("Could not save configuration data to file!", (Throwable)e);
        }
    }

    @Override
    public void load() throws ConfigurateException {
        String path;
        CommentedConfigurationNode section;
        String namespace;
        this.root = (CommentedConfigurationNode)this.loader.load();
        int version = ((CommentedConfigurationNode)this.root.node(new Object[]{"version"})).getInt(1);
        this.root.removeChild((Object)"version");
        if (version != 2) {
            Solstice.LOGGER.warn("Configuration version mismatch! Attempting migration...");
            this.migrate(version);
        }
        CommentedConfigurationNode defaults = (CommentedConfigurationNode)this.loader.createNode();
        ((CommentedConfigurationNode)((CommentedConfigurationNode)defaults.node(new Object[]{"version"})).comment("!! DO NOT CHANGE THIS VALUE !! Configuration version used for migrations.")).set((Object)2);
        Map<String, List<Map.Entry<class_2960, Class<?>>>> namespaces = this.getSections();
        for (Map.Entry<String, List<Map.Entry<class_2960, Class<?>>>> group : namespaces.entrySet()) {
            namespace = group.getKey();
            section = (CommentedConfigurationNode)defaults.node(new Object[]{namespace});
            for (Map.Entry<class_2960, Class<?>> entry : group.getValue()) {
                path = entry.getKey().method_12832();
                Supplier<?> creator = this.defaultSuppliers.get(entry.getValue());
                ((CommentedConfigurationNode)section.node(new Object[]{path})).set(creator.get());
            }
        }
        this.root.mergeFrom((ConfigurationNode)defaults);
        for (Map.Entry<String, List<Map.Entry<class_2960, Class<?>>>> group : namespaces.entrySet()) {
            namespace = group.getKey();
            section = (CommentedConfigurationNode)this.root.node(new Object[]{namespace});
            for (Map.Entry<class_2960, Class<?>> entry : group.getValue()) {
                path = entry.getKey().method_12832();
                Class<?> configClass = entry.getValue();
                Object obj = ((CommentedConfigurationNode)section.node(new Object[]{path})).get(configClass);
                this.dataMap.put(configClass, obj);
            }
        }
    }

    @Override
    public Path getPath() {
        return this.filePath;
    }

    protected void migrate(int version) {
        if (version > 2) {
            throw new IllegalArgumentException("Configuration file has a version higher than the supported version!");
        }
        for (int i = version; i < 2; ++i) {
            Solstice.LOGGER.info("Sequentially migrating configuration from version {} to version {}", (Object)i, (Object)(i + 1));
            if (i != 1) continue;
            this.migrateV1();
        }
    }

    private void migrateV1() {
        CommentedConfigurationNode newRoot = (CommentedConfigurationNode)this.loader.createNode();
        String defaultNamespace = Solstice.ID.method_12836();
        CommentedConfigurationNode section = (CommentedConfigurationNode)newRoot.node(new Object[]{defaultNamespace});
        for (Map.Entry entry : this.root.childrenMap().entrySet()) {
            String path = entry.getKey().toString();
            CommentedConfigurationNode node = (CommentedConfigurationNode)entry.getValue();
            ((CommentedConfigurationNode)section.node(new Object[]{path})).mergeFrom((ConfigurationNode)node);
        }
        this.root = newRoot;
    }
}

