/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.api.config.serializers;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Predicate;
import org.spongepowered.configurate.serialize.ScalarSerializer;

public final class DateSerializer
extends ScalarSerializer<Date> {
    public static final DateSerializer TYPE = new DateSerializer();
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    DateSerializer() {
        super(Date.class);
    }

    public Date deserialize(Type type, Object obj) {
        try {
            return DATE_FORMATTER.parse(obj.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Object serialize(Date item, Predicate<Class<?>> typeSupported) {
        return DATE_FORMATTER.format(item);
    }
}

