/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.core;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.module.ModuleEntrypoint;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_7157;

public class Modules {
    private final HashSet<ModuleBase> modules = new HashSet();

    public Modules() {
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
    }

    public void register() {
        this.modules.add(new CoreModule(Solstice.ID.method_45136("core")));
        FabricLoader fabric = FabricLoader.getInstance();
        List moduleContainers = fabric.getEntrypointContainers("solstice", ModuleEntrypoint.class);
        for (EntrypointContainer container : moduleContainers) {
            ModContainer mod = container.getProvider();
            ModMetadata modMeta = mod.getMetadata();
            Solstice.LOGGER.info("Registering module provider '{}' ({}) v{}", new Object[]{modMeta.getName(), modMeta.getId(), modMeta.getVersion()});
            try {
                ModuleEntrypoint provider = (ModuleEntrypoint)container.getEntrypoint();
                HashSet<ModuleBase> providerModules = provider.register();
                for (ModuleBase entry : providerModules) {
                    class_2960 moduleId = entry.getId();
                    if (this.modules.stream().anyMatch(m -> m.getId().equals((Object)moduleId))) {
                        Solstice.LOGGER.warn("Module ID conflict: {}", (Object)entry.getId());
                        continue;
                    }
                    this.modules.add(entry);
                }
            }
            catch (Exception e) {
                Solstice.LOGGER.error("Error registering a module from {}", (Object)modMeta.getId(), (Object)e);
            }
        }
    }

    public Collection<? extends ModuleBase> getModules() {
        return Collections.unmodifiableSet(this.modules);
    }

    public <T> Optional<T> getModule(Class<T> classOfModule) {
        for (ModuleBase module : this.modules) {
            if (!classOfModule.isInstance(module)) continue;
            return Optional.of(classOfModule.cast(module));
        }
        return Optional.empty();
    }

    public Collection<? extends ModuleBase> getEnabledModules() {
        HashSet set = new HashSet();
        this.getModules().forEach(module -> {
            if (module instanceof ModuleBase.Toggleable) {
                ModuleBase.Toggleable toggleable = (ModuleBase.Toggleable)module;
                if (toggleable.isEnabled()) {
                    set.add(module);
                }
            } else {
                set.add(module);
            }
        });
        return Collections.unmodifiableSet(set);
    }

    public void initModules() {
        Collection<? extends ModuleBase> enabledModules = this.getEnabledModules();
        for (ModuleBase moduleBase : enabledModules) {
            try {
                moduleBase.init();
            }
            catch (NoSuchMethodError e) {
                Solstice.LOGGER.error("Legacy module {} does not contain the init method. UPDATE!", (Object)moduleBase.getId(), (Object)e);
            }
            catch (Exception e) {
                Solstice.LOGGER.error("Error initializing module {}", (Object)moduleBase.getId(), (Object)e);
            }
        }
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        for (ModuleBase module : this.modules) {
            for (ModCommand<?> command : module.getCommands()) {
                command.register(dispatcher, commandRegistry, environment);
            }
        }
    }
}

