/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.alexdevs.solstice.Paths;

public class ToggleableConfig {
    public static final Pattern ENTRY_PATTERN = Pattern.compile("^\\s*(?<key>\\w+(?:[.:]\\w+)?)=(?<value>\\w+)");
    private static ToggleableConfig instance = null;
    private final Map<String, Boolean> modules = new HashMap<String, Boolean>();
    private final Path filePath;

    public static ToggleableConfig get() {
        if (instance == null) {
            instance = new ToggleableConfig(Paths.configDirectory.resolve("modules.conf"));
        }
        return instance;
    }

    ToggleableConfig(Path filePath) {
        this.filePath = filePath;
        this.load();
    }

    public boolean isEnabled(String id) {
        if (!((String)(id = ((String)id).replace(':', '.'))).contains(".")) {
            id = "solstice." + (String)id;
        }
        return this.modules.computeIfAbsent((String)id, i -> true);
    }

    private void load() {
        if (!this.filePath.toFile().exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.filePath.toFile()));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher matcher = ENTRY_PATTERN.matcher(line);
                if (!matcher.matches()) {
                    if (line.isBlank() || line.startsWith("#")) continue;
                    System.out.println("Malformed module config entry in solstice/modules.conf: " + line + ". Skipping.");
                    continue;
                }
                Object key = matcher.group("key").replace(':', '.');
                if (!((String)key).contains(".")) {
                    key = "solstice." + (String)key;
                }
                String value = matcher.group("value");
                boolean enabled = Boolean.parseBoolean(value);
                this.modules.put((String)key, enabled);
            }
        }
        catch (Exception e) {
            System.out.println("Error loading toggleable state of modules. Assuming all enabled. " + e.getMessage());
        }
    }

    public void save() {
        List<Entry> list = this.modules.entrySet().stream().map(e -> new Entry((String)e.getKey(), (Boolean)e.getValue())).sorted(Comparator.comparing(Entry::id)).toList();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.filePath.toFile()));){
            for (Entry entry : list) {
                bw.write(entry.id() + "=" + entry.enabled());
                bw.newLine();
            }
        }
        catch (Exception e2) {
            System.out.println("Error saving toggleable state of modules. Assuming all enabled in the next load." + e2.getMessage());
        }
    }

    private record Entry(String id, boolean enabled) {
    }
}

