/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import me.alexdevs.solstice.Solstice;

public class UserCache {
    private final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private final Map<String, Entry> byName = Maps.newConcurrentMap();
    private final Map<UUID, Entry> byUUID = Maps.newConcurrentMap();
    private final AtomicLong accessCount = new AtomicLong();
    private final File cacheFile;

    public UserCache(File cacheFile) {
        this.cacheFile = cacheFile;
        Lists.reverse(this.load()).forEach(this::add);
    }

    private long incrementAndGetAccessCount() {
        return this.accessCount.incrementAndGet();
    }

    public Optional<GameProfile> getByName(String name) {
        Entry entry = this.byName.get(name = name.toLowerCase(Locale.ROOT));
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.getProfile());
    }

    public Optional<GameProfile> getByUUID(UUID uuid) {
        Entry entry = this.byUUID.get(uuid);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry.getProfile());
    }

    public List<String> getAllNames() {
        return ImmutableList.copyOf(this.byName.keySet());
    }

    public void add(GameProfile profile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date date = calendar.getTime();
        Entry entry = new Entry(profile, date);
        this.add(entry);
    }

    private void add(Entry entry) {
        UUID uuid;
        GameProfile gameProfile = entry.getProfile();
        entry.setLastAccessed(this.incrementAndGetAccessCount());
        String name = gameProfile.getName();
        if (name != null) {
            this.byName.put(name.toLowerCase(Locale.ROOT), entry);
        }
        if ((uuid = gameProfile.getId()) != null) {
            this.byUUID.put(uuid, entry);
        }
    }

    private static JsonElement entryToJson(Entry entry, DateFormat dateFormat) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", entry.getProfile().getName());
        UUID uUID = entry.getProfile().getId();
        jsonObject.addProperty("uuid", uUID == null ? "" : uUID.toString());
        jsonObject.addProperty("expiresOn", dateFormat.format(entry.getExpirationDate()));
        return jsonObject;
    }

    private static Optional<Entry> entryFromJson(JsonElement json, DateFormat dateFormat) {
        if (!json.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject root = json.getAsJsonObject();
        JsonElement nameJson = root.get("name");
        JsonElement uuidJson = root.get("uuid");
        JsonElement expiresJson = root.get("expiresOn");
        if (nameJson == null || uuidJson == null) {
            return Optional.empty();
        }
        String uuid = uuidJson.getAsString();
        String name = nameJson.getAsString();
        Date date = null;
        if (expiresJson != null) {
            try {
                date = dateFormat.parse(expiresJson.getAsString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (name != null && uuid != null && date != null) {
            UUID uUID;
            try {
                uUID = UUID.fromString(uuid);
            }
            catch (Throwable e) {
                return Optional.empty();
            }
            return Optional.of(new Entry(new GameProfile(uUID, name), date));
        }
        return Optional.empty();
    }

    public List<Entry> load() {
        ArrayList<Entry> list = new ArrayList<Entry>();
        try {
            BufferedReader reader = Files.newReader((File)this.cacheFile, (Charset)StandardCharsets.UTF_8);
            try {
                JsonArray array = (JsonArray)this.gson.fromJson((Reader)reader, JsonArray.class);
                if (array == null) {
                    return list;
                }
                DateFormat dateFormat = UserCache.getDateFormat();
                array.forEach(json -> UserCache.entryFromJson(json, dateFormat).ifPresent(list::add));
            }
            catch (Exception e) {
                try {
                    reader.close();
                }
                catch (Throwable ee) {
                    e.addSuppressed(ee);
                }
            }
            if (reader != null) {
                reader.close();
            }
            return list;
        }
        catch (FileNotFoundException reader) {
        }
        catch (JsonParseException | IOException e) {
            Solstice.LOGGER.warn("Failed to load Solstice profile cache {}", (Object)this.cacheFile, (Object)e);
        }
        return list;
    }

    private void save() {
        JsonArray jsonArray = new JsonArray();
        DateFormat dateFormat = UserCache.getDateFormat();
        this.getLastAccessedEntries(1000).forEach(entry -> jsonArray.add(UserCache.entryToJson(entry, dateFormat)));
        String json = this.gson.toJson((JsonElement)jsonArray);
        try {
            BufferedWriter writer = Files.newWriter((File)this.cacheFile, (Charset)StandardCharsets.UTF_8);
            try {
                writer.write(json);
            }
            catch (IOException e) {
                try {
                    writer.close();
                }
                catch (IOException ee) {
                    e.addSuppressed(ee);
                }
                throw e;
            }
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<Entry> getLastAccessedEntries(int limit) {
        return ImmutableList.copyOf(this.byUUID.values()).stream().sorted(Comparator.comparing(Entry::getLastAccessed).reversed()).limit(limit);
    }

    private static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    }

    public static class Entry {
        private final GameProfile profile;
        final Date expirationDate;
        private volatile long lastAccessed;

        Entry(GameProfile profile, Date expirationDate) {
            this.profile = profile;
            this.expirationDate = expirationDate;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setLastAccessed(long lastAccessed) {
            this.lastAccessed = lastAccessed;
        }

        public long getLastAccessed() {
            return this.lastAccessed;
        }
    }
}

