/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.core.coreModule.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.module.Debug;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1268;
import net.minecraft.class_155;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class SolsticeCommand
extends ModCommand<CoreModule> {
    public SolsticeCommand(CoreModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("solstice", "sol");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).executes(context -> {
            ModContainer modContainer = FabricLoader.getInstance().getModContainer("solstice").orElse(null);
            if (modContainer == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Could not find self in mod list???"), false);
                return 1;
            }
            ModMetadata metadata = modContainer.getMetadata();
            Map<String, class_2561> placeholders = Map.of("name", class_2561.method_30163((String)metadata.getName()), "version", class_2561.method_30163((String)metadata.getVersion().getFriendlyString()));
            class_2561 text = Format.parse("<gold>${name} v${version}</gold>", placeholders);
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        })).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(this.require("reload", 3))).executes(context -> {
            try {
                Solstice.configManager.load();
                Solstice.localeManager.reload();
            }
            catch (Exception e) {
                Solstice.LOGGER.error("Failed to reload Solstice", (Throwable)e);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Failed to load Solstice config. Check console for more info."), true);
                return 1;
            }
            ((SolsticeEvents.Reload)SolsticeEvents.RELOAD.invoker()).onReload(Solstice.getInstance());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Reloaded Solstice config"), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reloaduser").requires(this.require("reloaduser", 3))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests(LocalGameProfile::suggest).executes(context -> {
            GameProfile profile = LocalGameProfile.getProfile((CommandContext<class_2168>)context, "player");
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)("Force reloading player data for " + profile.getName())), true);
            Solstice.playerData.forceLoad(profile.getId());
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(this.require("debug", 4))).then(class_2170.method_9247((String)"gen-command-list").executes(context -> {
            StringBuilder builder = new StringBuilder();
            ArrayList<Debug.CommandDebug> list = new ArrayList<Debug.CommandDebug>(Debug.commandDebugList);
            list.sort(Comparator.comparing(Debug.CommandDebug::module));
            builder.append(String.format("| %s | %s | %s | %s |\n", "Module", "Command", "Aliases", "Permission"));
            builder.append("|---|---|---|---|\n");
            for (Debug.CommandDebug command : list) {
                builder.append(String.format("| %s | %s | %s | %s |\n", command.module(), command.command(), String.join((CharSequence)" ", command.commands()), command.permission()));
            }
            String output = builder.toString();
            File file = FabricLoader.getInstance().getGameDir().resolve("solstice-commands.md").toFile();
            try (FileWriter fw = new FileWriter(file);){
                fw.write(output);
            }
            catch (IOException e) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)e.getMessage())).create();
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_30163((String)"Generated 'solstice-commands.md'"), true);
            return 1;
        }))).then(class_2170.method_9247((String)"tags").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1268 hand = player.method_6058();
            class_1799 itemStack = player.method_5998(hand);
            class_5321 entry = (class_5321)itemStack.method_41409().method_40230().get();
            String entryString = String.format("Tags for [%s / %s]:", entry.method_41185(), entry.method_29177());
            class_5250 text = class_2561.method_43473();
            text.method_10852(class_2561.method_30163((String)entryString));
            Iterator tags = itemStack.method_40133().iterator();
            while (tags.hasNext()) {
                class_6862 tag = (class_6862)tags.next();
                text.method_10852(class_2561.method_30163((String)"\n"));
                text.method_10852((class_2561)class_2561.method_43470((String)(" #" + String.valueOf(tag.comp_327()))).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Click to copy"))).method_10958(new class_2558(class_2558.class_2559.field_21462, "#" + String.valueOf(tag.comp_327())))));
            }
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        }))).then(class_2170.method_9247((String)"enable").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"enable", (ArgumentType)BoolArgumentType.bool()).requires(this.require("debug.enable", 4))).executes(context -> {
            boolean enable;
            class_155.field_1125 = enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            if (enable) {
                class_2561 message = SolsticeCommand.notice("<red><obf>!</obf> WARNING <obf>!</obf></red> <yellow>Debug mode has been enabled. This state may result in instabilities!</yellow>");
                ((class_2168)context.getSource()).method_9226(() -> message, true);
            } else {
                class_2561 message = SolsticeCommand.notice("Debug mode has been disabled");
                ((class_2168)context.getSource()).method_9226(() -> message, true);
            }
            return 1;
        }))));
    }

    private static class_2561 notice(String text) {
        return Format.parse("[<gold>Solstice</gold>] " + text);
    }
}

