/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.data;

import com.mojang.authlib.GameProfile;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.data.PlayerData;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlayerDataManager {
    private final Map<class_2960, Class<?>> classMap = new HashMap();
    private final Map<Class<?>, Supplier<?>> providers = new HashMap();
    private final Map<UUID, PlayerData> playerData = new ConcurrentHashMap<UUID, PlayerData>();
    private Path basePath;

    public Path getDataPath() {
        return this.basePath;
    }

    public void setDataPath(Path basePath) {
        this.basePath = basePath;
    }

    public <T> void registerData(class_2960 id, Class<T> clazz, Supplier<T> creator) {
        this.classMap.put(id, clazz);
        this.providers.put(clazz, creator);
    }

    public PlayerData get(UUID uuid) {
        if (!this.playerData.containsKey(uuid)) {
            return this.load(uuid);
        }
        return this.playerData.get(uuid);
    }

    public PlayerData get(class_3222 player) {
        return this.get(player.method_5667());
    }

    public PlayerData get(GameProfile profile) {
        return this.get(profile.getId());
    }

    public void dispose(UUID uuid) {
        if (this.playerData.containsKey(uuid)) {
            Solstice.LOGGER.debug("Unloading player data {}", (Object)uuid);
            PlayerData data = this.playerData.remove(uuid);
            data.save();
        }
    }

    public void disposeMissing(List<UUID> uuids) {
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.entrySet()) {
            if (uuids.contains(entry.getKey())) continue;
            this.dispose(entry.getKey());
        }
    }

    public void forceLoad(UUID uuid) {
        this.load(uuid);
    }

    private PlayerData load(UUID uuid) {
        Solstice.LOGGER.debug("Loading player data {}", (Object)uuid);
        PlayerData data = new PlayerData(this.basePath, uuid, this.classMap, this.providers);
        this.playerData.put(uuid, data);
        return data;
    }

    public void saveAll() {
        if (!this.basePath.toFile().exists()) {
            this.basePath.toFile().mkdirs();
        }
        for (Map.Entry<UUID, PlayerData> entry : this.playerData.entrySet()) {
            PlayerData data = entry.getValue();
            data.save();
        }
    }
}

