/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.afk.data;

import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class AfkConfig {
    @Comment(value="Enable the AFK functionality. Requires server restart.")
    public boolean enable = true;
    @Comment(value="Announce in chat when a player goes or return from AFK.")
    public boolean announce = true;
    @Comment(value="AFK triggers after the player has been inactive for the following seconds. Defaults to 300 seconds.")
    public int timeTrigger = 300;
    @Comment(value="This tag is displayed with `solstice:afk` placeholder when the player is AFK.")
    public String tag = "<gray>[AFK]</gray> ";
    @Comment(value="These triggers clear the AFK status. Events regarding entities, blocks or item usage may be triggered by fake players.")
    public AfkTriggers triggers = new AfkTriggers();

    @ConfigSerializable
    public static class AfkTriggers {
        @Comment(value="Movement is triggered when the velocity threshold is met.")
        public boolean onMovement = true;
        @Comment(value="Look change is triggered when the player yaw and/or pitch change.")
        public boolean onLookChange = true;
        @Comment(value="Trigger on chat messages sent by the player.")
        public boolean onChat = true;
        @Comment(value="Trigger on commands.")
        public boolean onCommand = true;
        @Comment(value="Trigger when a block is being attacked (left click).")
        public boolean onBlockAttack = true;
        @Comment(value="Trigger when a block is being interacted with (right click).")
        public boolean onBlockInteract = true;
        @Comment(value="Trigger when an entity is attacked.")
        public boolean onEntityAttack = true;
        @Comment(value="Trigger when an entity is interacted with.")
        public boolean onEntityInteract = true;
        @Comment(value="Trigger when an item is used.")
        public boolean onItemUse = true;
    }
}

