/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.back;

import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.events.PlayerTeleportCallback;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.back.commands.BackCommand;
import me.alexdevs.solstice.modules.back.data.BackConfig;
import me.alexdevs.solstice.modules.back.data.BackLocale;
import me.alexdevs.solstice.modules.back.data.BackPlayerData;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class BackModule
extends ModuleBase.Toggleable {
    public BackModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerLocale(BackLocale.MODULE);
        this.registerConfig(BackConfig.class, BackConfig::new);
        this.registerPlayerData(BackPlayerData.class, BackPlayerData::new);
        this.commands.add(new BackCommand(this));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            BackConfig config = this.getConfig();
            if (!config.persistLocation) {
                this.clearOfflinePlayerLastLocation(handler.method_32311().method_5667());
            } else if (config.offlineClearTimeout >= 0) {
                Solstice.scheduler.schedule(() -> this.clearOfflinePlayerLastLocation(handler.method_32311().method_5667()), (long)config.offlineClearTimeout, TimeUnit.SECONDS);
            }
        });
        PlayerTeleportCallback.EVENT.register((player, origin, destination) -> this.setPlayerLastLocation(player.method_5667(), origin));
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity.method_31747()) {
                try {
                    class_3222 player = (class_3222)entity;
                    this.setPlayerLastLocation(entity.method_5667(), new ServerLocation(player));
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        });
    }

    public void clearOfflinePlayerLastLocation(UUID uuid) {
        boolean isOnline;
        boolean bl = isOnline = Solstice.server.method_3760().method_14602(uuid) != null;
        if (isOnline) {
            return;
        }
        BackPlayerData data = this.getPlayerData(uuid);
        data.lastTeleportLocation = null;
        data.lastTeleportDate = null;
    }

    public void setPlayerLastLocation(UUID uuid, ServerLocation location) {
        BackPlayerData data = this.getPlayerData(uuid);
        data.lastTeleportLocation = location;
        data.lastTeleportDate = new Date();
    }

    @Nullable
    public ServerLocation getPlayerLastLocation(UUID uuid) {
        BackConfig config = this.getConfig();
        BackPlayerData data = this.getPlayerData(uuid);
        Date lastTeleportDate = data.lastTeleportDate;
        if (lastTeleportDate == null) {
            return null;
        }
        long timeDelta = BackModule.getDateDifference(lastTeleportDate, new Date());
        if (config.clearTimeout >= 0 && timeDelta > (long)config.clearTimeout) {
            return null;
        }
        return data.lastTeleportLocation;
    }

    public BackConfig getConfig() {
        return Solstice.configManager.getData(BackConfig.class);
    }

    public BackPlayerData getPlayerData(UUID uuid) {
        return Solstice.playerData.get(uuid).getData(BackPlayerData.class);
    }

    public static long getDateDifference(Date start, Date end) {
        return (end.getTime() - start.getTime()) / 1000L;
    }
}

