/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.ban.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.module.Utils;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.ban.BanModule;
import me.alexdevs.solstice.modules.ban.formatters.BanMessageFormatter;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BanCommand
extends ModCommand<BanModule> {
    public static final SimpleCommandExceptionType ALREADY_BANNED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ban.failed"));

    public BanCommand(BanModule module) {
        super(module);
    }

    static int execute(CommandContext<class_2168> context, Collection<GameProfile> targets, @Nullable String reason, @Nullable Date expiryDate) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        MinecraftServer server = source.method_9211();
        class_3335 banList = server.method_3760().method_14563();
        int banCounter = 0;
        for (GameProfile target : targets) {
            if (banList.method_14650(target)) continue;
            class_3336 banEntry = new class_3336(target, null, source.method_9214(), expiryDate, reason);
            banList.method_14633((class_3330)banEntry);
            ++banCounter;
            PlaceholderContext playerContext = PlaceholderContext.of((GameProfile)target, (MinecraftServer)server);
            source.method_9226(() -> class_2561.method_43469((String)"commands.ban.success", (Object[])new Object[]{class_2561.method_30163((String)target.getName()), Format.parse(banEntry.method_14503(), playerContext)}), true);
            class_3222 serverPlayerEntity = source.method_9211().method_3760().method_14602(target.getId());
            if (serverPlayerEntity == null) continue;
            serverPlayerEntity.field_13987.method_52396(BanMessageFormatter.format(target, banEntry));
        }
        if (banCounter == 0) {
            throw ALREADY_BANNED_EXCEPTION.create();
        }
        return banCounter;
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandRegistry, class_2170.class_5364 environment) {
        Utils.removeCommands(dispatcher, "ban");
        super.register(dispatcher, commandRegistry, environment);
    }

    @Override
    public List<String> getNames() {
        return List.of("ban");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(3))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2191.method_9329()).executes(context -> BanCommand.execute((CommandContext<class_2168>)context, class_2191.method_9330((CommandContext)context, (String)"targets"), null, null))).then(class_2170.method_9244((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(context -> BanCommand.execute((CommandContext<class_2168>)context, class_2191.method_9330((CommandContext)context, (String)"targets"), StringArgumentType.getString((CommandContext)context, (String)"reason"), null))));
    }
}

