/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.customName;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.api.text.RawPlaceholder;
import me.alexdevs.solstice.integrations.LuckPermsIntegration;
import me.alexdevs.solstice.modules.customName.commands.NicknameCommand;
import me.alexdevs.solstice.modules.customName.data.CustomNameConfig;
import me.alexdevs.solstice.modules.customName.data.CustomNameLocale;
import me.alexdevs.solstice.modules.customName.data.CustomNamePlayerData;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class CustomNameModule
extends ModuleBase.Toggleable {
    public static final Pattern BASIC_NICKNAME_FILTER = Pattern.compile("[^a-zA-Z\u00e0-\u00fc\u00c0-\u00dc_ ]");

    public CustomNameModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(CustomNameConfig.class, CustomNameConfig::new);
        this.registerLocale(CustomNameLocale.MODULE);
        this.registerPlayerData(CustomNamePlayerData.class, CustomNamePlayerData::new);
        this.commands.add(new NicknameCommand(this));
    }

    public String fetchUsernameFormat(class_3222 player) {
        ArrayList<CustomNameConfig.NameFormat> formats = Solstice.configManager.getData(CustomNameConfig.class).nameFormats;
        String format = null;
        for (CustomNameConfig.NameFormat f : formats) {
            if (!LuckPermsIntegration.isInGroup(player, f.group())) continue;
            format = f.format();
            break;
        }
        boolean isOperator = player.method_5682().method_3760().method_14569(player.method_7334());
        if (format == null) {
            format = "${username}";
            for (CustomNameConfig.NameFormat f : formats) {
                if (isOperator && f.group().equals("operator")) {
                    format = f.format();
                    break;
                }
                if (!f.group().equals("default")) continue;
                format = f.format();
                break;
            }
        }
        return format;
    }

    public String getResolvedUsername(class_3222 player) {
        String format = this.fetchUsernameFormat(player);
        CustomNamePlayerData playerData = Solstice.playerData.get(player).getData(CustomNamePlayerData.class);
        String name = playerData.nickname == null ? player.method_7334().getName() : playerData.nickname;
        String prefix = LuckPermsIntegration.getPrefix(player);
        String suffix = LuckPermsIntegration.getSuffix(player);
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        Map<String, String> placeholders = Map.of("name", name, "prefix", prefix, "suffix", suffix);
        return RawPlaceholder.parse(format, placeholders);
    }

    public class_5250 getNameForPlayer(class_3222 player) {
        String name = this.getResolvedUsername(player);
        PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
        return Format.parse(name, playerContext).method_27661();
    }

    @Nullable
    public String getCustomName(class_3222 player) {
        return this.getCustomName(player.method_5667());
    }

    @Nullable
    public String getCustomName(UUID uuid) {
        CustomNamePlayerData playerData = Solstice.playerData.get(uuid).getData(CustomNamePlayerData.class);
        return playerData.nickname;
    }

    public void setCustomName(class_3222 player, String name) {
        this.setCustomName(player, name, true);
    }

    public void setCustomName(class_3222 player, String name, boolean advancedFormatting) {
        this.setCustomName(player.method_5667(), name, advancedFormatting);
    }

    public void setCustomName(UUID uuid, String name, boolean advancedFormatting) {
        if (!advancedFormatting) {
            name = BASIC_NICKNAME_FILTER.matcher(name).replaceAll("");
        }
        CustomNamePlayerData playerData = Solstice.playerData.get(uuid).getData(CustomNamePlayerData.class);
        playerData.nickname = name;
    }

    public void clearCustomName(class_3222 player) {
        this.clearCustomName(player.method_5667());
    }

    public void clearCustomName(UUID uuid) {
        CustomNamePlayerData playerData = Solstice.playerData.get(uuid).getData(CustomNamePlayerData.class);
        playerData.nickname = null;
    }
}

