/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.customName.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.customName.CustomNameModule;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class NicknameCommand
extends ModCommand<CustomNameModule> {
    public NicknameCommand(CustomNameModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("nickname", "nick");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).then(class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.string()).executes(this::executeSetSelf))).then(class_2170.method_9247((String)"clear").executes(this::executeClearSelf))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).requires(this.require("others", 2))).suggests(LocalGameProfile::suggest).then(class_2170.method_9244((String)"nickname", (ArgumentType)StringArgumentType.string()).executes(this::executeSetOthers))).then(class_2170.method_9247((String)"clear").executes(this::executeClearOthers)));
    }

    private boolean hasAdvancedPermission(class_2168 source) {
        return Permissions.check((class_2172)source, (String)this.getPermissionNode("advanced.base"), (int)2);
    }

    private boolean hasAdvancedPermissionOthers(class_2168 source) {
        return Permissions.check((class_2172)source, (String)this.getPermissionNode("advanced.others"), (int)3);
    }

    private int executeSetSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String nickname = StringArgumentType.getString(context, (String)"nickname");
        if (nickname.isEmpty()) {
            ((class_2168)context.getSource()).method_9213(((CustomNameModule)this.module).locale().get("errorEmpty"));
            return 0;
        }
        ((CustomNameModule)this.module).setCustomName(player, nickname, this.hasAdvancedPermission((class_2168)context.getSource()));
        Map<String, class_2561> map = Map.of("player", player.method_5477(), "nickname", class_2561.method_30163((String)((CustomNameModule)this.module).getCustomName(player)));
        ((class_2168)context.getSource()).method_9226(() -> ((CustomNameModule)this.module).locale().get("setSelf", map), true);
        return 1;
    }

    private int executeClearSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ((CustomNameModule)this.module).clearCustomName(player);
        Map<String, class_2561> map = Map.of("player", player.method_5477(), "nickname", class_2561.method_30163((String)((CustomNameModule)this.module).getCustomName(player)));
        ((class_2168)context.getSource()).method_9226(() -> ((CustomNameModule)this.module).locale().get("clearedSelf", map), true);
        return 1;
    }

    private int executeSetOthers(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameProfile profile = LocalGameProfile.getProfile(context, "player");
        String nickname = StringArgumentType.getString(context, (String)"nickname");
        if (nickname.isEmpty()) {
            ((class_2168)context.getSource()).method_9213(((CustomNameModule)this.module).locale().get("errorEmpty"));
            return 0;
        }
        ((CustomNameModule)this.module).setCustomName(profile.getId(), nickname, this.hasAdvancedPermissionOthers((class_2168)context.getSource()));
        Map<String, class_2561> map = Map.of("player", class_2561.method_30163((String)profile.getName()), "nickname", class_2561.method_30163((String)((CustomNameModule)this.module).getCustomName(profile.getId())));
        ((class_2168)context.getSource()).method_9226(() -> ((CustomNameModule)this.module).locale().get("setOther", map), true);
        return 1;
    }

    private int executeClearOthers(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameProfile profile = LocalGameProfile.getProfile(context, "player");
        ((CustomNameModule)this.module).clearCustomName(profile.getId());
        Map<String, class_2561> map = Map.of("player", class_2561.method_30163((String)profile.getName()), "nickname", class_2561.method_30163((String)((CustomNameModule)this.module).getCustomName(profile.getId())));
        ((class_2168)context.getSource()).method_9226(() -> ((CustomNameModule)this.module).locale().get("clearedOther", map), true);
        return 1;
    }
}

