/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.info;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.alexdevs.solstice.Paths;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.modules.info.commands.InfoCommand;
import me.alexdevs.solstice.modules.info.commands.MotdCommand;
import me.alexdevs.solstice.modules.info.commands.RulesCommand;
import me.alexdevs.solstice.modules.info.data.InfoConfig;
import me.alexdevs.solstice.modules.info.data.InfoLocale;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class InfoModule
extends ModuleBase.Toggleable {
    private static final String[] startingPages = new String[]{"motd.txt", "rules.txt", "formatting.txt"};
    public final String nameFilterRegex = "[^a-z0-9-]";
    private final Path infoDir = Paths.configDirectory.resolve("info");

    public InfoModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(InfoConfig.class, InfoConfig::new);
        this.registerLocale(InfoLocale.MODULE);
        this.commands.add(new InfoCommand(this));
        this.commands.add(new MotdCommand(this));
        this.commands.add(new RulesCommand(this));
        if (!this.infoDir.toFile().isDirectory()) {
            if (!this.infoDir.toFile().mkdirs()) {
                Solstice.LOGGER.error("Couldn't create info directory");
                return;
            }
            ClassLoader classLoader = Solstice.class.getClassLoader();
            String infoDirBase = "assets/" + this.id.method_12836() + "/info/";
            for (String name : startingPages) {
                Path outputPath = this.infoDir.resolve(name);
                try (InputStream inputStream = classLoader.getResourceAsStream(infoDirBase + name);){
                    if (inputStream == null) {
                        Solstice.LOGGER.warn("Missing {} info file in resources, skipping", (Object)name);
                        continue;
                    }
                    byte[] content = inputStream.readAllBytes();
                    Files.write(outputPath, content, new OpenOption[0]);
                }
                catch (IOException e) {
                    Solstice.LOGGER.error("Could not read info file {} from resources", (Object)name, (Object)e);
                }
            }
        }
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (this.getConfig().enableMotd) {
                if (!this.exists("motd")) {
                    Solstice.LOGGER.warn("Could not send MOTD because info/motd.txt does not exist!");
                    return;
                }
                Solstice.nextTick(() -> {
                    class_2561 motd = this.buildMotd(PlaceholderContext.of((class_3222)handler.method_32311()));
                    handler.method_32311().method_43496(motd);
                });
            }
        });
    }

    public InfoConfig getConfig() {
        return Solstice.configManager.getData(InfoConfig.class);
    }

    public class_2561 buildMotd(PlaceholderContext context) {
        return this.getPage("motd", context);
    }

    private String sanitize(String name) {
        return name.toLowerCase().replaceAll("[^a-z0-9-]", "");
    }

    public Collection<String> enumerate() {
        return Arrays.stream(Objects.requireNonNull(this.infoDir.toFile().listFiles())).map(f -> f.getName().replace(".txt", "")).toList();
    }

    public boolean exists(String name) {
        name = this.sanitize(name);
        Path infoFile = this.infoDir.resolve(name + ".txt");
        return infoFile.toFile().exists();
    }

    public class_2561 getPage(String name, @Nullable PlaceholderContext context) {
        if (!this.exists(name = this.sanitize(name))) {
            return this.locale().get("pageNotFound");
        }
        Path infoFile = this.infoDir.resolve(name + ".txt");
        try {
            List<String> lines = Files.readAllLines(infoFile, StandardCharsets.UTF_8);
            StringBuilder content = new StringBuilder();
            for (String line : lines) {
                content.append(line).append("\n");
            }
            String output = content.toString().trim();
            if (context != null) {
                return Format.parse(output, context);
            }
            return class_2561.method_30163((String)output);
        }
        catch (IOException e) {
            Solstice.LOGGER.error("Could not read info file", (Throwable)e);
            return this.locale().get("pageError");
        }
    }
}

