/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.jail.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.core.coreModule.data.CoreConfig;
import me.alexdevs.solstice.modules.jail.JailModule;
import me.alexdevs.solstice.modules.jail.data.JailPlayerData;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class CheckJailCommand
extends ModCommand<JailModule> {
    public CheckJailCommand(JailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("checkjail");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).then(class_2170.method_9244((String)"user", (ArgumentType)StringArgumentType.word()).suggests(LocalGameProfile::suggest).executes(context -> {
            Optional opProfile;
            GameProfile user = LocalGameProfile.getProfile((CommandContext<class_2168>)context, "user");
            JailPlayerData data = ((JailModule)this.module).getPlayer(user.getId());
            if (!data.jailed) {
                ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("notJailed"), false);
                return 0;
            }
            String operator = new UUID(0L, 0L).equals(data.jailedBy) ? "Server" : ((opProfile = ((class_2168)context.getSource()).method_9211().method_3793().method_14512(data.jailedBy)).isPresent() ? ((GameProfile)opProfile.get()).getName() : (data.jailedBy != null ? data.jailedBy.toString() : "Unknown"));
            String reason = data.jailReason != null ? data.jailReason : ((JailModule)this.module).locale().raw("infoJailReasonEmpty");
            String duration = data.jailTime == 0 ? ((JailModule)this.module).locale().raw("infoJailedForEmpty") : TimeSpan.toLongString(data.jailTime);
            CoreConfig coreConfig = Solstice.configManager.getData(CoreConfig.class);
            SimpleDateFormat df = new SimpleDateFormat(coreConfig.dateTimeFormat);
            Map<String, class_2561> map = Map.of("player", class_2561.method_30163((String)user.getName()), "jail", class_2561.method_30163((String)data.jailName), "operator", class_2561.method_30163((String)operator), "reason", class_2561.method_30163((String)reason), "duration", class_2561.method_30163((String)duration), "date", class_2561.method_30163((String)df.format(data.jailedOn)));
            class_5250 text = class_2561.method_43473();
            text.method_10852(((JailModule)this.module).locale().get("infoHeader", map));
            text.method_27693("\n");
            text.method_10852(((JailModule)this.module).locale().get("infoJailedAt", map));
            text.method_27693("\n");
            text.method_10852(((JailModule)this.module).locale().get("infoJailedBy", map));
            text.method_27693("\n");
            text.method_10852(((JailModule)this.module).locale().get("infoJailReason", map));
            text.method_27693("\n");
            text.method_10852(((JailModule)this.module).locale().get("infoJailedFor", map));
            text.method_27693("\n");
            text.method_10852(((JailModule)this.module).locale().get("infoJailedOn", map));
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        }));
    }
}

