/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.jail.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import me.alexdevs.solstice.api.ServerLocation;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.jail.JailModule;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class JailsCommand
extends ModCommand<JailModule> {
    public JailsCommand(JailModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("jails");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).executes(this::listJails)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(this.require("set", 3))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(this::createJail)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(this.require("set", 3))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::suggestJails).executes(this::deleteJail)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tp").requires(this.require("tp", 2))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::suggestJails).executes(this::teleport)));
    }

    private CompletableFuture<Suggestions> suggestJails(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        Stream jails = ((JailModule)this.module).getJails().keySet().stream();
        return class_2172.method_9264(jails, (SuggestionsBuilder)builder);
    }

    private int listJails(CommandContext<class_2168> context) {
        List jails = ((JailModule)this.module).getJails().keySet().stream().toList();
        if (jails.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("noJails"), false);
            return 0;
        }
        class_2561 comma = ((JailModule)this.module).locale().get("comma");
        class_5250 list = class_2561.method_43473();
        for (int i = 0; i < jails.size(); ++i) {
            if (i > 0) {
                list.method_10852(comma);
            }
            list.method_10852(((JailModule)this.module).locale().get("listEntry", Map.of("jail", class_2561.method_30163((String)((String)jails.get(i))))));
        }
        ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("jailList", Map.of("list", list)), false);
        return 1;
    }

    private int createJail(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String jailName = StringArgumentType.getString(context, (String)"name");
        ServerLocation position = new ServerLocation(player);
        Map<String, ServerLocation> jails = ((JailModule)this.module).getJails();
        if (jails.containsKey(jailName)) {
            ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("jailAlreadyExists"), false);
            return 0;
        }
        jails.put(jailName, position);
        Map<String, class_2561> map = Map.of("jail", class_2561.method_30163((String)jailName));
        ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("created", map), true);
        return 1;
    }

    private int deleteJail(CommandContext<class_2168> context) {
        String jailName = StringArgumentType.getString(context, (String)"name");
        Map<String, ServerLocation> jails = ((JailModule)this.module).getJails();
        if (!jails.containsKey(jailName)) {
            ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("jailNotFound"), false);
            return 0;
        }
        jails.remove(jailName);
        Map<String, class_2561> map = Map.of("jail", class_2561.method_30163((String)jailName));
        ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("deleted", map), true);
        return 1;
    }

    private int teleport(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String jailName = StringArgumentType.getString(context, (String)"name");
        Map<String, ServerLocation> jails = ((JailModule)this.module).getJails();
        if (!jails.containsKey(jailName)) {
            ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("jailNotFound"), false);
            return 0;
        }
        ServerLocation jail = jails.get(jailName);
        Map<String, class_2561> map = Map.of("jail", class_2561.method_30163((String)jailName));
        ((class_2168)context.getSource()).method_9226(() -> ((JailModule)this.module).locale().get("teleporting", map), true);
        jail.teleport(player);
        return 1;
    }
}

