/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.kit.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.command.TimeSpan;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.kit.KitInventory;
import me.alexdevs.solstice.modules.kit.KitModule;
import me.alexdevs.solstice.modules.kit.Utils;
import me.alexdevs.solstice.modules.kit.data.Kit;
import me.alexdevs.solstice.modules.kit.data.KitPlayerData;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class KitCommand
extends ModCommand<KitModule> {
    public KitCommand(KitModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("kit");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).then(class_2170.method_9247((String)"list").executes(this::listKits))).then(class_2170.method_9247((String)"claim").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::suggestKitList).executes(this::claimKit)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(this.require("set", 3))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(this::createKit)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(this.require("set", 3))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::suggestAllKits).executes(this::deleteKit)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"edit").requires(this.require("set", 3))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::suggestKitList).executes(this::editKit)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(this.require("set", 3))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this::suggestAllKits).then(class_2170.method_9247((String)"first-join").then(class_2170.method_9244((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(this::setFirstJoin)))).then(class_2170.method_9247((String)"cooldown").then(class_2170.method_9244((String)"timespan", (ArgumentType)StringArgumentType.word()).suggests(TimeSpan::suggest).executes(this::setCooldown)))).then(class_2170.method_9247((String)"one-time").then(class_2170.method_9244((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(this::setOneTime)))).then(class_2170.method_9247((String)"icon").executes(this::setIcon))));
    }

    private int listKits(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        List<String> kits = ((KitModule)this.module).getPlayerKitNames(player);
        if (kits.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("listNoKits"), false);
            return 0;
        }
        class_2561 comma = ((KitModule)this.module).locale().get("listComma");
        class_5250 items = class_2561.method_43473();
        for (int i = 0; i < kits.size(); ++i) {
            String kit = kits.get(i);
            if (((KitModule)this.module).couldClaimKit(player, kit)) {
                items.method_10852(((KitModule)this.module).locale().get("listAvailableKit", Map.of("kit", class_2561.method_30163((String)kit))));
            } else {
                items.method_10852(((KitModule)this.module).locale().get("listUnavailableKit", Map.of("kit", class_2561.method_30163((String)kit))));
            }
            if (i >= kits.size() - 1) continue;
            items.method_10852(comma);
        }
        class_2561 list = ((KitModule)this.module).locale().get("listHeader", Map.of("list", items));
        ((class_2168)context.getSource()).method_9226(() -> list, false);
        return 1;
    }

    private int claimKit(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        if (!((KitModule)this.module).hasKitPermission(player, name = StringArgumentType.getString(context, (String)"name"))) {
            source.method_9226(() -> ((KitModule)this.module).locale().get("noPermission", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        Map<String, Kit> kits = ((KitModule)this.module).getKits();
        if (!kits.containsKey(name)) {
            source.method_9226(() -> ((KitModule)this.module).locale().get("notFound", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        Kit kit = kits.get(name);
        KitPlayerData playerData = Solstice.playerData.get(player).getData(KitPlayerData.class);
        if (kit.oneTime && playerData.claimedKits.containsKey(name)) {
            source.method_9226(() -> ((KitModule)this.module).locale().get("alreadyClaimed", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        if (kit.cooldownSeconds > 0 && playerData.claimedKits.containsKey(name)) {
            Date startDate = playerData.claimedKits.get(name);
            Date nowDate = new Date();
            long delta = (nowDate.getTime() - startDate.getTime()) / 1000L;
            if (delta < (long)kit.cooldownSeconds) {
                long remaining = (long)kit.cooldownSeconds - delta;
                String timespan = TimeSpan.toShortString((int)remaining);
                source.method_9226(() -> ((KitModule)this.module).locale().get("onCooldown", Map.of("kit", class_2561.method_30163((String)name), "timespan", class_2561.method_30163((String)timespan))), false);
                return 0;
            }
        }
        ((KitModule)this.module).claimKit(player, name);
        source.method_9226(() -> ((KitModule)this.module).locale().get("claimed", Map.of("kit", class_2561.method_30163((String)name))), false);
        return 1;
    }

    private int createKit(CommandContext<class_2168> context) throws CommandSyntaxException {
        final class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        final String name = StringArgumentType.getString(context, (String)"name");
        if (((KitModule)this.module).getKits().containsKey(name)) {
            source.method_9226(() -> ((KitModule)this.module).locale().get("alreadyExists"), false);
            return 0;
        }
        final KitInventory kitInventory = new KitInventory();
        SimpleGui container = new SimpleGui(class_3917.field_17326, player, false){

            public void onClose() {
                if (((KitModule)KitCommand.this.module).createKit(name, Utils.getItemStacks(kitInventory))) {
                    source.method_9226(() -> ((KitModule)KitCommand.this.module).locale().get("created", Map.of("kit", class_2561.method_30163((String)name))), true);
                } else {
                    source.method_9226(() -> ((KitModule)KitCommand.this.module).locale().get("alreadyExists"), false);
                }
            }
        };
        Utils.redirect(container, kitInventory);
        container.setTitle(((KitModule)this.module).locale().get("newKitTitle", Map.of("kit", class_2561.method_30163((String)name))));
        container.open();
        return 1;
    }

    private int deleteKit(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        if (((KitModule)this.module).getKits().remove(name) != null) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("deleted", Map.of("kit", class_2561.method_30163((String)name))), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("notFound", Map.of("kit", class_2561.method_30163((String)name))), false);
        }
        return 1;
    }

    private int editKit(CommandContext<class_2168> context) throws CommandSyntaxException {
        final class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        final String name = StringArgumentType.getString(context, (String)"name");
        Map<String, Kit> kits = ((KitModule)this.module).getKits();
        if (!kits.containsKey(name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("notFound", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        final Kit kit = kits.get(name);
        final KitInventory kitInventory = Utils.createInventory(kit.getItemStacks());
        SimpleGui container = new SimpleGui(class_3917.field_17326, player, false){

            public void onClose() {
                List<class_1799> items = Utils.getItemStacks(kitInventory);
                kit.itemStacks = items.stream().map(Utils::serializeItemStack).toList();
                source.method_9226(() -> ((KitModule)KitCommand.this.module).locale().get("edited", Map.of("kit", class_2561.method_30163((String)name))), true);
            }
        };
        Utils.redirect(container, kitInventory);
        container.setTitle(((KitModule)this.module).locale().get("editKitTitle", Map.of("kit", class_2561.method_30163((String)name))));
        container.open();
        return 1;
    }

    private int setFirstJoin(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        boolean enable = BoolArgumentType.getBool(context, (String)"enable");
        Map<String, Kit> kits = ((KitModule)this.module).getKits();
        if (!kits.containsKey(name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("notFound", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        Kit kit = kits.get(name);
        kit.firstJoin = enable;
        ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("setFirstJoin", Map.of("kit", class_2561.method_30163((String)name), "value", class_2561.method_30163((String)String.valueOf(enable)))), true);
        return 1;
    }

    private int setCooldown(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        int timespan = TimeSpan.getTimeSpan(context, "timespan");
        Map<String, Kit> kits = ((KitModule)this.module).getKits();
        if (!kits.containsKey(name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("notFound", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        Kit kit = kits.get(name);
        kit.cooldownSeconds = timespan;
        ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("setCooldown", Map.of("kit", class_2561.method_30163((String)name), "value", class_2561.method_30163((String)TimeSpan.toShortString(timespan)))), true);
        return 1;
    }

    private int setOneTime(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        boolean enable = BoolArgumentType.getBool(context, (String)"enable");
        Map<String, Kit> kits = ((KitModule)this.module).getKits();
        if (!kits.containsKey(name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("notFound", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        Kit kit = kits.get(name);
        kit.oneTime = enable;
        ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("setOneTime", Map.of("kit", class_2561.method_30163((String)name), "value", class_2561.method_30163((String)String.valueOf(enable)))), true);
        return 1;
    }

    private int setIcon(CommandContext<class_2168> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Map<String, Kit> kits = ((KitModule)this.module).getKits();
        if (!kits.containsKey(name)) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("notFound", Map.of("kit", class_2561.method_30163((String)name))), false);
            return 0;
        }
        class_1268 hand = player.method_6058();
        class_1799 stack = player.method_5998(hand).method_7972();
        if (stack.method_7960()) {
            ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("noStackInHand"), false);
            return 0;
        }
        Kit kit = kits.get(name);
        kit.icon = Utils.serializeItemStack(stack);
        ((class_2168)context.getSource()).method_9226(() -> ((KitModule)this.module).locale().get("setIcon", Map.of("kit", class_2561.method_30163((String)name))), true);
        return 1;
    }

    private CompletableFuture<Suggestions> suggestAllKits(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        Set<String> kits = ((KitModule)this.module).getKits().keySet();
        return class_2172.method_9265(kits, (SuggestionsBuilder)builder);
    }

    private CompletableFuture<Suggestions> suggestKitList(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return class_2172.method_9265(((KitModule)this.module).getPlayerKitNames(player), (SuggestionsBuilder)builder);
    }
}

