/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.mail;

import eu.pb4.placeholders.api.PlaceholderContext;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.ignore.data.IgnorePlayerData;
import me.alexdevs.solstice.modules.mail.commands.MailCommand;
import me.alexdevs.solstice.modules.mail.data.MailLocale;
import me.alexdevs.solstice.modules.mail.data.MailPlayerData;
import me.alexdevs.solstice.modules.mail.data.PlayerMail;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class MailModule
extends ModuleBase.Toggleable {
    public MailModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerLocale(MailLocale.MODULE);
        this.registerPlayerData(MailPlayerData.class, MailPlayerData::new);
        this.commands.add(new MailCommand(this));
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            PlaceholderContext playerContext = PlaceholderContext.of((class_3222)player);
            Solstice.scheduler.schedule(() -> {
                if (!this.getMailData((UUID)player.method_5667()).mails.isEmpty()) {
                    player.method_43496(this.locale().get("mailPending", playerContext));
                }
            }, 1L, TimeUnit.SECONDS);
        });
    }

    public boolean sendMail(UUID playerUuid, PlayerMail mail) {
        IgnorePlayerData playerData = ModuleProvider.IGNORE.getPlayerData(playerUuid);
        if (playerData.ignoredPlayers.contains(mail.sender)) {
            return false;
        }
        this.getMailData((UUID)playerUuid).mails.add(mail);
        return true;
    }

    public List<PlayerMail> getMailList(UUID playerUuid) {
        return this.getMailData((UUID)playerUuid).mails.stream().toList();
    }

    public boolean deleteMail(UUID playerUuid, int index) {
        MailPlayerData mailData = this.getMailData(playerUuid);
        if (index < 0 || index >= mailData.mails.size()) {
            return false;
        }
        mailData.mails.remove(index);
        return true;
    }

    public void clearAllMail(UUID playerUuid) {
        this.getMailData((UUID)playerUuid).mails.clear();
    }

    public MailPlayerData getMailData(UUID playerUuid) {
        return Solstice.playerData.get(playerUuid).getData(MailPlayerData.class);
    }
}

