/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.note.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.alexdevs.solstice.api.command.LocalGameProfile;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.text.Components;
import me.alexdevs.solstice.api.text.Format;
import me.alexdevs.solstice.core.coreModule.CoreModule;
import me.alexdevs.solstice.modules.note.NoteModule;
import me.alexdevs.solstice.modules.note.data.Note;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class NotesCommand
extends ModCommand<NoteModule> {
    public NotesCommand(NoteModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("notes", "note");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"user", (ArgumentType)StringArgumentType.word()).suggests(LocalGameProfile::suggest).executes(this::listNotes)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(this.require("add", 2))).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(this::addNote)))).then(class_2170.method_9247((String)"check").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::checkNote)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(this.require("delete", 2))).then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(this::deleteNote)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(this.require("clear", 2))).executes(this::clearNotes)));
    }

    private int listNotes(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameProfile user = LocalGameProfile.getProfile(context, "user");
        List<Note> notes = ((NoteModule)this.module).getNotes(user.getId());
        if (notes.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> ((NoteModule)this.module).locale().get("emptyNotes"), false);
            return 0;
        }
        class_5250 output = class_2561.method_43473().method_10852(((NoteModule)this.module).locale().get("noteListHeader", Map.of("user", class_2561.method_30163((String)user.getName())))).method_10852(class_2561.method_30163((String)"\n"));
        for (int i = 0; i < notes.size(); ++i) {
            if (i > 0) {
                output = output.method_10852(class_2561.method_30163((String)"\n"));
            }
            Note note = notes.get(i);
            class_2561 checkButton = Components.button(((NoteModule)this.module).locale().raw("checkButton"), ((NoteModule)this.module).locale().raw("hoverCheck"), "/notes " + user.getName() + " check " + i);
            String senderName = CoreModule.getUsername(note.createdBy);
            SimpleDateFormat dateFormatter = new SimpleDateFormat(CoreModule.getConfig().dateTimeFormat);
            Map<String, class_2561> placeholders = Map.of("index", class_2561.method_30163((String)String.valueOf(i)), "operator", class_2561.method_30163((String)senderName), "date", class_2561.method_30163((String)dateFormatter.format(note.creationDate)), "message", Format.parse(note.note), "checkButton", checkButton);
            output = output.method_10852(((NoteModule)this.module).locale().get("noteListEntry", placeholders));
        }
        class_5250 finalOutput = output;
        ((class_2168)context.getSource()).method_9226(() -> finalOutput, false);
        return 1;
    }

    private int checkNote(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameProfile user = LocalGameProfile.getProfile(context, "user");
        List<Note> notes = ((NoteModule)this.module).getNotes(user.getId());
        int index = IntegerArgumentType.getInteger(context, (String)"index");
        if (index < 0 || index >= notes.size()) {
            ((class_2168)context.getSource()).method_9226(() -> ((NoteModule)this.module).locale().get("notFound"), false);
            return 0;
        }
        Note note = notes.get(index);
        class_2561 deleteButton = Components.button(((NoteModule)this.module).locale().raw("deleteButton"), ((NoteModule)this.module).locale().raw("hoverDelete"), "/note " + user.getName() + " delete " + index);
        String operator = CoreModule.getUsername(note.createdBy);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(CoreModule.getConfig().dateTimeFormat);
        Map<String, class_2561> placeholders = Map.of("operator", class_2561.method_30163((String)operator), "date", class_2561.method_30163((String)dateFormatter.format(note.creationDate)), "message", Format.parse(note.note), "deleteButton", deleteButton);
        ((class_2168)context.getSource()).method_9226(() -> ((NoteModule)this.module).locale().get("noteDetails", placeholders), false);
        return 1;
    }

    private int deleteNote(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameProfile user = LocalGameProfile.getProfile(context, "user");
        List<Note> notes = ((NoteModule)this.module).getNotes(user.getId());
        int index = IntegerArgumentType.getInteger(context, (String)"index");
        if (index >= notes.size()) {
            ((class_2168)context.getSource()).method_9226(() -> ((NoteModule)this.module).locale().get("notFound"), false);
            return 0;
        }
        notes.remove(index);
        ((class_2168)context.getSource()).method_9226(() -> ((NoteModule)this.module).locale().get("noteDeleted"), false);
        return 1;
    }

    private int addNote(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameProfile user = LocalGameProfile.getProfile(context, "user");
        UUID operatorId = new UUID(0L, 0L);
        if (((class_2168)context.getSource()).method_43737()) {
            operatorId = ((class_2168)context.getSource()).method_44023().method_5667();
        }
        String message = StringArgumentType.getString(context, (String)"message");
        Note note = new Note(message, operatorId);
        List<Note> notes = ((NoteModule)this.module).getNotes(user.getId());
        notes.add(note);
        int index = notes.size() - 1;
        ((class_2168)context.getSource()).method_9226(() -> ((NoteModule)this.module).locale().get("noteAdded"), false);
        class_2561 checkButton = Components.button(((NoteModule)this.module).locale().raw("checkButton"), ((NoteModule)this.module).locale().raw("hoverCheck"), "/notes " + user.getName() + " check " + index);
        class_2561 text = ((NoteModule)this.module).locale().get("addedNotification", Map.of("operator", ((class_2168)context.getSource()).method_9223(), "user", class_2561.method_30163((String)user.getName()), "checkButton", checkButton));
        ((class_2168)context.getSource()).method_9211().method_3760().method_14571().forEach(pl -> {
            if (Permissions.check((class_1297)pl, (String)this.getPermissionNode("notify"), (int)2)) {
                pl.method_43496(text);
            }
        });
        return 1;
    }

    private int clearNotes(CommandContext<class_2168> context) throws CommandSyntaxException {
        GameProfile user = LocalGameProfile.getProfile(context, "user");
        List<Note> notes = ((NoteModule)this.module).getNotes(user.getId());
        notes.clear();
        ((class_2168)context.getSource()).method_9226(() -> ((NoteModule)this.module).locale().get("notesCleared", Map.of("user", class_2561.method_30163((String)user.getName()))), true);
        return 1;
    }
}

