/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.notifications.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.modules.notifications.NotificationsModule;
import me.alexdevs.solstice.modules.notifications.data.NotificationsPlayerData;
import me.alexdevs.solstice.modules.notifications.data.PlayerNotificationSettings;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class NotificationsCommand
extends ModCommand<NotificationsModule> {
    public NotificationsCommand(NotificationsModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("notifications");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").then(class_2170.method_9247((String)"sound").then(class_2170.method_9244((String)"sound", (ArgumentType)class_2232.method_9441()).suggests(class_2321.field_10934).executes(this::setSound)))).then(class_2170.method_9247((String)"pitch").then(class_2170.method_9244((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(this::setPitch)))).then(class_2170.method_9247((String)"volume").then(class_2170.method_9244((String)"volume", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(this::setVolume)))).then(class_2170.method_9247((String)"afk-only").then(class_2170.method_9244((String)"afk-only", (ArgumentType)BoolArgumentType.bool()).executes(this::setAfkOnly)))).then(class_2170.method_9247((String)"on-chat").then(class_2170.method_9244((String)"on-chat", (ArgumentType)BoolArgumentType.bool()).executes(this::setOnChat))))).then(class_2170.method_9247((String)"get").executes(this::getSettings))).then(class_2170.method_9247((String)"toggle").executes(this::toggle))).then(class_2170.method_9247((String)"reset").executes(this::reset));
    }

    private int setSound(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_2960 soundId = class_2232.method_9443(context, (String)"sound");
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        data.soundId = soundId.toString();
        Map<String, class_2561> map = Map.of("sound", class_2561.method_30163((String)soundId.toString()));
        ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("setSound", map), false);
        return 1;
    }

    private int setPitch(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        float pitch = FloatArgumentType.getFloat(context, (String)"pitch");
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        data.pitch = Float.valueOf(pitch);
        Map<String, class_2561> map = Map.of("pitch", class_2561.method_30163((String)String.valueOf(pitch)));
        ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("setPitch", map), false);
        return 1;
    }

    private int setVolume(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        int volume = IntegerArgumentType.getInteger(context, (String)"volume");
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        data.volume = Float.valueOf((float)volume / 100.0f);
        Map<String, class_2561> map = Map.of("volume", class_2561.method_30163((String)(volume + "%")));
        ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("setVolume", map), false);
        return 1;
    }

    private int setAfkOnly(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        boolean afkOnly = BoolArgumentType.getBool(context, (String)"afk-only");
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        data.afkOnly = afkOnly;
        if (afkOnly) {
            ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("setAfkOnlyEnabled"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("setAfkOnlyDisabled"), false);
        }
        return 1;
    }

    private int setOnChat(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        boolean onChat = BoolArgumentType.getBool(context, (String)"on-chat");
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        data.onChat = onChat;
        if (onChat) {
            ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("setOnChatEnabled"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("setOnChatDisabled"), false);
        }
        return 1;
    }

    private int getSettings(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        PlayerNotificationSettings settings = ((NotificationsModule)this.module).getPlayerSettings(player);
        Map<String, class_2561> map = Map.of("sound", class_2561.method_30163((String)settings.soundId()), "pitch", class_2561.method_30163((String)String.valueOf(settings.pitch())), "volume", class_2561.method_30163((String)(settings.volume() * 100.0f + "%")));
        class_5250 text = class_2561.method_43473();
        text.method_10852(((NotificationsModule)this.module).locale().get("getHeader"));
        text.method_27693("\n");
        text.method_10852(((NotificationsModule)this.module).locale().get(data.enable ? "getEnabled.true" : "getEnabled.false"));
        text.method_27693("\n");
        text.method_10852(((NotificationsModule)this.module).locale().get("getSound", map));
        text.method_27693("\n");
        text.method_10852(((NotificationsModule)this.module).locale().get("getPitch", map));
        text.method_27693("\n");
        text.method_10852(((NotificationsModule)this.module).locale().get("getVolume", map));
        text.method_27693("\n");
        text.method_10852(((NotificationsModule)this.module).locale().get(settings.afkOnly() ? "getAfkOnly.true" : "getAfkOnly.false"));
        text.method_27693("\n");
        text.method_10852(((NotificationsModule)this.module).locale().get(settings.onChat() ? "getOnChat.true" : "getOnChat.false"));
        ((class_2168)context.getSource()).method_9226(() -> text, false);
        return 1;
    }

    private int toggle(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        boolean bl = data.enable = !data.enable;
        if (data.enable) {
            ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("toggleEnabled"), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("toggleDisabled"), false);
        }
        return 1;
    }

    private int reset(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        NotificationsPlayerData data = ((NotificationsModule)this.module).getPlayerData(player);
        data.soundId = null;
        data.pitch = null;
        data.volume = null;
        data.afkOnly = null;
        ((class_2168)context.getSource()).method_9226(() -> ((NotificationsModule)this.module).locale().get("reset"), false);
        return 1;
    }
}

