/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.powertool;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Map;
import java.util.UUID;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.modules.powertool.Action;
import me.alexdevs.solstice.modules.powertool.commands.PowerToolCommand;
import me.alexdevs.solstice.modules.powertool.data.PowerToolLocale;
import me.alexdevs.solstice.modules.powertool.data.PowerToolPlayerData;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class PowerToolModule
extends ModuleBase.Toggleable {
    private CommandDispatcher<class_2168> dispatcher;

    public PowerToolModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerLocale(PowerToolLocale.MODULE);
        this.registerPlayerData(PowerToolPlayerData.class, PowerToolPlayerData::new);
        this.commands.add(new PowerToolCommand(this));
        CommandRegistrationCallback.EVENT.register((dispatcher, registry, environment) -> {
            this.dispatcher = dispatcher;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                Map<Action, String> powertool;
                PowerToolPlayerData data = this.getData(player.method_5667());
                String itemId = this.getStackId(stack);
                if (data.powerTools.containsKey(itemId) && (powertool = data.powerTools.get(itemId)).containsKey((Object)Action.USE)) {
                    class_2168 source = player.method_5671();
                    this.execute(source, powertool.get((Object)Action.USE), PlaceholderContext.of((class_1297)player));
                    return class_1271.method_22428((Object)stack);
                }
            }
            return class_1271.method_22430((Object)stack);
        });
        AttackBlockCallback.EVENT.register((player, world, hand, blockPos, direction) -> {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                Map<Action, String> powertool;
                PowerToolPlayerData data = this.getData(player.method_5667());
                String itemId = this.getStackId(stack);
                if (data.powerTools.containsKey(itemId) && (powertool = data.powerTools.get(itemId)).containsKey((Object)Action.ATTACK_BLOCK)) {
                    class_2168 source = player.method_5671();
                    this.execute(source, powertool.get((Object)Action.ATTACK_BLOCK), PlaceholderContext.of((class_1297)player));
                    return class_1269.field_21466;
                }
            }
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                Map<Action, String> powertool;
                PowerToolPlayerData data = this.getData(player.method_5667());
                String itemId = this.getStackId(stack);
                if (data.powerTools.containsKey(itemId) && (powertool = data.powerTools.get(itemId)).containsKey((Object)Action.ATTACK_ENTITY)) {
                    class_2168 source = player.method_5671();
                    this.execute(source, powertool.get((Object)Action.ATTACK_ENTITY), PlaceholderContext.of((class_1297)entity));
                    return class_1269.field_21466;
                }
            }
            return class_1269.field_5811;
        });
        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                Map<Action, String> powertool;
                PowerToolPlayerData data = this.getData(player.method_5667());
                String itemId = this.getStackId(stack);
                if (data.powerTools.containsKey(itemId) && (powertool = data.powerTools.get(itemId)).containsKey((Object)Action.INTERACT_BLOCK)) {
                    class_2168 source = player.method_5671();
                    this.execute(source, powertool.get((Object)Action.INTERACT_BLOCK), PlaceholderContext.of((class_1297)player));
                    return class_1269.field_21466;
                }
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hit) -> {
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960()) {
                Map<Action, String> powertool;
                PowerToolPlayerData data = this.getData(player.method_5667());
                String itemId = this.getStackId(stack);
                if (data.powerTools.containsKey(itemId) && (powertool = data.powerTools.get(itemId)).containsKey((Object)Action.INTERACT_ENTITY)) {
                    class_2168 source = player.method_5671();
                    this.execute(source, powertool.get((Object)Action.INTERACT_ENTITY), PlaceholderContext.of((class_1297)entity));
                    return class_1269.field_21466;
                }
            }
            return class_1269.field_5811;
        });
    }

    public void execute(class_2168 source, String command, PlaceholderContext context) {
        try {
            this.dispatcher.execute(this.resolveCommand(command, context), (Object)source);
        }
        catch (CommandSyntaxException e) {
            source.method_9213(class_2561.method_30163((String)e.getMessage()));
        }
    }

    private String resolveCommand(String command, PlaceholderContext context) {
        return Placeholders.parseText((class_2561)class_2561.method_30163((String)command), (PlaceholderContext)context).getString();
    }

    public String getStackId(class_1799 stack) {
        return ((class_5321)stack.method_41409().method_40230().get()).method_29177().toString();
    }

    public PowerToolPlayerData getData(UUID uuid) {
        return Solstice.playerData.get(uuid).getData(PowerToolPlayerData.class);
    }
}

