/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.restart;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.events.RestartEvents;
import me.alexdevs.solstice.api.events.SolsticeEvents;
import me.alexdevs.solstice.api.events.TimeBarEvents;
import me.alexdevs.solstice.api.module.ModuleBase;
import me.alexdevs.solstice.integrations.ConnectorIntegration;
import me.alexdevs.solstice.modules.ModuleProvider;
import me.alexdevs.solstice.modules.restart.commands.RestartCommand;
import me.alexdevs.solstice.modules.restart.data.RestartConfig;
import me.alexdevs.solstice.modules.restart.data.RestartLocale;
import me.alexdevs.solstice.modules.timeBar.TimeBar;
import me.alexdevs.solstice.modules.timeBar.TimeBarModule;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class RestartModule
extends ModuleBase.Toggleable {
    private static final class_1259.class_1260 fallbackBarColor = class_1259.class_1260.field_5784;
    private static final class_1259.class_1261 fallbackBarStyle = class_1259.class_1261.field_5791;
    private TimeBar restartBar = null;
    private class_3414 sound;
    private ScheduledFuture<?> currentSchedule = null;

    public RestartModule(class_2960 id) {
        super(id);
    }

    @Override
    public void init() {
        this.registerConfig(RestartConfig.class, RestartConfig::new);
        this.registerLocale(RestartLocale.MODULE);
        this.commands.add(new RestartCommand(this));
        SolsticeEvents.READY.register((instance, server) -> {
            this.setup();
            if (this.getConfig().enable) {
                this.scheduleNextRestart();
            }
        });
        TimeBarEvents.PROGRESS.register((timeBar, server) -> {
            if (this.restartBar == null || !timeBar.getUuid().equals(this.restartBar.getUuid())) {
                return;
            }
            ArrayList<Integer> notificationTimes = this.getConfig().restartNotifications;
            int remainingSeconds = this.restartBar.getRemainingSeconds();
            if (notificationTimes.contains(remainingSeconds)) {
                this.notifyRestart(server, this.restartBar);
            }
        });
        TimeBarEvents.END.register((timeBar, server) -> {
            if (this.restartBar == null || !timeBar.getUuid().equals(this.restartBar.getUuid())) {
                return;
            }
            this.restart();
        });
        SolsticeEvents.RELOAD.register(instance -> this.setup());
    }

    @Override
    public boolean isEnabled() {
        if (!ModuleProvider.TIMEBAR.isEnabled()) {
            return false;
        }
        return super.isEnabled();
    }

    public RestartConfig getConfig() {
        return Solstice.configManager.getData(RestartConfig.class);
    }

    public class_1259.class_1261 getBarStyle() {
        String styleName = this.getConfig().barStyle;
        try {
            return class_1259.class_1261.valueOf((String)styleName);
        }
        catch (IllegalArgumentException e) {
            Solstice.LOGGER.error("Invalid value in `restart -> bar-style` setting.");
            return fallbackBarStyle;
        }
    }

    public class_1259.class_1260 getBarColor() {
        String colorName = this.getConfig().barColor;
        try {
            return class_1259.class_1260.valueOf((String)colorName);
        }
        catch (IllegalArgumentException e) {
            Solstice.LOGGER.error("Invalid value in `restart -> bar-color` setting.");
            return fallbackBarColor;
        }
    }

    public void restart() {
        if (!ConnectorIntegration.isForge()) {
            class_2561 kickMessage = this.locale().get("kickMessage");
            for (class_3222 player : Solstice.server.method_3760().method_14571()) {
                try {
                    player.field_13987.method_52396(kickMessage);
                }
                catch (Exception e) {
                    Solstice.LOGGER.error("An error occurred while disconnecting player {}", (Object)player, (Object)e);
                }
            }
        } else {
            Solstice.LOGGER.warn("Kicking players with restart message is not compatible with Forge at the moment.");
        }
        Solstice.server.method_3747(false);
    }

    private void setup() {
        String soundName = this.getConfig().restartSound;
        class_2960 id = class_2960.method_12829((String)soundName);
        if (id == null) {
            Solstice.LOGGER.error("Invalid restart notification sound name {}", (Object)soundName);
            this.sound = (class_3414)class_3417.field_14793.comp_349();
        } else {
            this.sound = class_3414.method_47908((class_2960)id);
        }
    }

    public void schedule(int seconds, String message, RestartEvents.RestartType restartType) {
        if (this.isRunning()) {
            Solstice.LOGGER.warn("Could not start a new restart countdown because there is one already running.");
            return;
        }
        Optional<TimeBarModule> timeBar = Solstice.modules.getModule(TimeBarModule.class);
        this.restartBar = ModuleProvider.TIMEBAR.startTimeBar(message, seconds, this.getBarColor(), this.getBarStyle(), true);
        ((RestartEvents.Schedule)RestartEvents.SCHEDULED.invoker()).onSchedule(this.restartBar, restartType);
    }

    public boolean isScheduled() {
        return this.restartBar != null || this.currentSchedule != null && !this.currentSchedule.isCancelled();
    }

    public boolean isRunning() {
        return this.restartBar != null;
    }

    public void cancel() {
        Optional<TimeBarModule> timeBar = Solstice.modules.getModule(TimeBarModule.class);
        if (this.restartBar != null) {
            ModuleProvider.TIMEBAR.cancelTimeBar(this.restartBar);
            ((RestartEvents.Cancel)RestartEvents.CANCELED.invoker()).onCancel(this.restartBar);
            this.restartBar = null;
        }
        if (this.currentSchedule != null) {
            this.currentSchedule.cancel(false);
            this.currentSchedule = null;
        }
    }

    private void notifyRestart(MinecraftServer server, TimeBar bar) {
        Solstice solstice = Solstice.getInstance();
        class_2561 text = bar.parseLabel(this.locale().raw("chatMessage"));
        solstice.broadcast(text);
        float pitch = this.getConfig().restartSoundPitch;
        server.method_3760().method_14571().forEach(player -> player.method_17356(this.sound, class_3419.field_15250, 1.0f, pitch));
    }

    @Nullable
    public Long scheduleNextRestart() {
        Long delay = this.getNextDelay();
        if (delay == null) {
            return null;
        }
        Integer barTime = this.getConfig().restartNotifications.stream().max(Integer::compareTo).orElse(600);
        long barStartTime = delay - (long)barTime.intValue();
        this.currentSchedule = Solstice.scheduler.schedule(() -> this.schedule(barTime, this.locale().raw("barLabel"), RestartEvents.RestartType.AUTOMATIC), barStartTime, TimeUnit.SECONDS);
        Solstice.LOGGER.info("Restart scheduled for in {} seconds", (Object)delay);
        return delay;
    }

    @Nullable
    private Long getNextDelay() {
        ArrayList<String> restartTimeStrings = this.getConfig().restartAt;
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime nextRunTime = null;
        long shortestDelay = Long.MAX_VALUE;
        for (String timeString : restartTimeStrings) {
            long delay;
            LocalTime targetTime = LocalTime.parse(timeString);
            LocalDateTime targetDateTime = now.with(targetTime);
            if (targetDateTime.isBefore(now)) {
                targetDateTime = targetDateTime.plusDays(1L);
            }
            if ((delay = Duration.between(now, targetDateTime).toSeconds()) >= shortestDelay) continue;
            shortestDelay = delay;
            nextRunTime = targetDateTime;
        }
        if (nextRunTime != null) {
            return shortestDelay;
        }
        return null;
    }
}

