/*
 * Decompiled with CFR 0.152.
 */
package me.alexdevs.solstice.modules.rtp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.alexdevs.solstice.Solstice;
import me.alexdevs.solstice.api.module.ModCommand;
import me.alexdevs.solstice.api.utils.RegistryUtils;
import me.alexdevs.solstice.modules.rtp.RTPModule;
import me.alexdevs.solstice.modules.rtp.core.Locator;
import me.alexdevs.solstice.modules.rtp.data.RTPConfig;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7733;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class RTPCommand
extends ModCommand<RTPModule> {
    public RTPCommand(RTPModule module) {
        super(module);
    }

    @Override
    public List<String> getNames() {
        return List.of("rtp");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> command(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(this.require(2))).executes(context -> this.execute((CommandContext<class_2168>)context, false))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"biome", (ArgumentType)class_7733.method_45603((class_7157)this.commandRegistry, (class_5321)class_7924.field_41236)).requires(this.require("biome.base", 2))).suggests((context, builder) -> {
            if (Permissions.check((class_2172)((class_2172)context.getSource()), (String)this.getPermissionNode("exempt.biome"), (int)2)) {
                Optional biomeRegistry = this.commandRegistry.method_46759(class_7924.field_41236);
                List<String> biomes = RegistryUtils.getBiomes((class_7225.class_7226<class_1959>)((class_7225.class_7226)biomeRegistry.get()), false);
                return class_2172.method_9265(biomes, (SuggestionsBuilder)builder);
            }
            List<String> biomes = this.getAllowedBiomes((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9225());
            return class_2172.method_9265(biomes, (SuggestionsBuilder)builder);
        }).executes(context -> this.execute((CommandContext<class_2168>)context, true)));
    }

    private int execute(CommandContext<class_2168> context, boolean withBiome) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        RTPConfig config = ((RTPModule)this.module).getConfig();
        if (config.requireWorldPermission) {
            String worldName = player.method_51469().method_27983().method_29177().toString();
            if (!Permissions.check((class_2172)((class_2172)context.getSource()), (String)this.getPermissionNode("worlds." + worldName), (int)2)) {
                ((class_2168)context.getSource()).method_9226(() -> ((RTPModule)this.module).locale().get("noWorldPermission", Map.of("world", class_2561.method_30163((String)worldName))), false);
                return 0;
            }
        }
        class_5321 biome = null;
        if (withBiome) {
            class_6880.class_6883 biomeEntry = class_7733.method_45602(context, (String)"biome", (class_5321)class_7924.field_41236);
            biome = biomeEntry.method_40230().orElse(null);
            if (biomeEntry.method_40230().isPresent() && !Permissions.check((class_2172)((class_2172)context.getSource()), (String)this.getPermissionNode("exempt.biome"), (int)2)) {
                String biomeId = biome.method_29177().toString();
                List<String> allowedBiomes = this.getAllowedBiomes((class_2168)context.getSource(), ((class_2168)context.getSource()).method_9225());
                if (!allowedBiomes.contains(biomeId)) {
                    ((class_2168)context.getSource()).method_9226(() -> ((RTPModule)this.module).locale().get("noBiomePermission"), false);
                    return 0;
                }
            }
        }
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        UUID uuid = player.method_5667();
        Locator locator = !withBiome ? ((RTPModule)this.module).createLocator(player) : ((RTPModule)this.module).createLocatorWithBiome(player, (class_5321<class_1959>)biome);
        locator.locate(result -> {
            class_3222 newPlayer = server.method_3760().method_14602(uuid);
            if (newPlayer == null) {
                Solstice.LOGGER.info("RTP spot found, but player left.");
                return;
            }
            if (result.position().isPresent() && result.type() == Locator.Result.Type.SUCCESS) {
                player.method_43496(((RTPModule)this.module).locale().get("success"));
                result.position().get().teleport(player);
            } else {
                class_2561 text = switch (result.type()) {
                    case Locator.Result.Type.TOO_MANY_ATTEMPTS -> ((RTPModule)this.module).locale().get("tooManyAttempts");
                    case Locator.Result.Type.TIMEOUT -> ((RTPModule)this.module).locale().get("timeout");
                    case Locator.Result.Type.UNSAFE -> ((RTPModule)this.module).locale().get("unsafe");
                    default -> class_2561.method_30163((String)result.type().toString());
                };
                player.method_43496(text);
            }
        });
        ((class_2168)context.getSource()).method_9226(() -> ((RTPModule)this.module).locale().get("searching"), false);
        return 1;
    }

    private List<String> getAllowedBiomes(class_2168 source, class_3218 world) {
        List<String> groups = this.getAllowedGroups(source, world);
        ArrayList<String> biomes = new ArrayList<String>();
        groups.forEach(group -> biomes.addAll(this.getBiomesInGroup(world, (String)group)));
        return biomes;
    }

    private List<String> getBiomesInGroup(class_3218 world, String group) {
        RTPConfig config = ((RTPModule)this.module).getConfig();
        Map<String, Map<String, List<String>>> worlds = config.biomeGroups;
        String worldId = world.method_27983().method_29177().toString();
        if (!worlds.containsKey(worldId)) {
            return List.of();
        }
        Map<String, List<String>> groups = worlds.get(worldId);
        if (!groups.containsKey(group)) {
            return List.of();
        }
        return groups.get(group);
    }

    private List<String> getAllowedGroups(class_2168 source, class_3218 world) {
        String worldId = world.method_27983().method_29177().toString();
        if (Permissions.check((class_2172)source, (String)this.getPermissionNode("biomes." + worldId + ".base"), (int)2)) {
            RTPConfig config = ((RTPModule)this.module).getConfig();
            return config.biomeGroups.getOrDefault(worldId, Map.of()).keySet().stream().filter(name -> Permissions.check((class_2172)source, (String)this.getPermissionNode("biomes." + worldId + "." + name), (int)2)).toList();
        }
        return List.of();
    }
}

